{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main pad-static">

	{if !empty($section.gallery)}
		<div class="intro-banner">
			{assign var=banner value=$section.gallery|element:'position':'banner'}
			{if !empty($banner)}
				<div class="intro-banner__bg" data-swiper-parallax="90%">
					<picture>
						<source srcset="{$banner.medium}"  media="(max-width: 550px)" />
						<source srcset="{$banner.medium}"  media="(max-width: 768px)" />
						<source srcset="{$banner.large}"  media="(max-width: 1024px)" />
						<source srcset="{$banner.original}"  media="(max-width: 1440px)" />
						<img src="{$banner.original}" alt="{$banner.title}"/>
					</picture>
				</div>
			{/if}

			<div class="intro-banner__info">
				<div class="flex:col-max">
					<div class="intro-banner__info-desc" data-swiper-parallax="600">
						<div class="text-tmp title-44 color-white mar-all-20">
							<h1>{$section.name}</h1>
							{$section.content nofilter}
						</div>
						<button class="btn green-saturated" data-modal-id="modalDetails">Обсудить детали <div class="btn__icons"></div></button>
					</div>
				</div>
			</div>
		</div>
	{/if}

	{fetch_section assign=advantageSection from=$section.sectionId getContent=true}{if !empty($advantageSection) && $advantageSection.status eq 'V'}
	<section class="flex:col pad-tb-90">
		<div class="flex:col-max">

			{fetch_sections assign=catalogSections from=$section.sectionId status="V" image=true getContent=true}
			<div class="grid:fr-1 g-gap-20">
				<div class="service">
					<div class="service__doble">
						{foreach item=subcatalog from=$catalogSections name=catalogSections}
						<div class="service-card">
							<div class="service-card__img"><img src="{$subcatalog.image.original}" alt="{$subcatalog.name}"></div>
							<div class="service-card__info">
								<div class="text-tmp color-white title-24 txt-14 mar-all-10">
									<h3>{$subcatalog.name}</h3>
									{$subcatalog.content nofilter}
								</div>

								<a class="btn green-saturated transparent" href="{$SITE_URL}{$subcatalog.url}">Узнать больше <div class="btn__icons"></div></a>
							</div>
						</div>
						{/foreach}
					</div>
				</div>
			</div>

		</div>
	</section>
	{/if}

	{* Наши проекты *}
	{include file="blocks/block-projects.tpl"}
	{* Наши проекты *}

	{* Готовы обсудить *}
	{include file="blocks/block-discuss.tpl"}
	{* /Готовы обсудить *}

	{* Непонятный блок карусель текст *}
	{include file="blocks/block-carousel-text.tpl"}
	{* /Непонятный блок карусель текст *}

	{* FAQ / Помощь *}
	{fetch_section assign=faqSection section=11}{if $faqSection.status eq 'V'}
	<section class="flex:col pad-tb-90 bg-light-g">
		<div class="flex:col-max">

			{* block FAQ / Помощь *}
			{include file="blocks/block-faq.tpl" name=$faqSection.name}
			{* block FAQ / Помощь *}

		</div>
	</section>
	{/if}
	{* FAQ / Помощь *}
	
	
	{* Контакты *}
	{include file="blocks/block-contacts.tpl" classBG="bg-white"}
	{* Контакты *}

</main>

{include file="footer.tpl"}