{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main pad-static">

	{if !empty($section.gallery)}
		{assign var=banner value=$section.gallery|element:'position':'banner'}
		{if !empty($banner)}
			<section class="flex:col">
				<div class="intro-common">
					<div class="intro-common__bg">
						<picture>
							<source srcset="{$banner.medium}"  media="(max-width: 550px)" />
							<source srcset="{$banner.medium}"  media="(max-width: 768px)" />
							<source srcset="{$banner.large}"  media="(max-width: 1024px)" />
							<source srcset="{$banner.original}"  media="(max-width: 1440px)" />
							<img src="{$banner.original}" alt="{$banner.title}"/>
						</picture>
					</div>
					<div class="flex:col-max">
						<div class="intro-common__info">
							<div class="text-tmp title-44 color-white all-center"><h1>{$section.name}</h1></div>
						</div>
					</div>
				</div>
			</section>
		{/if}
	{/if}


	<section class=" flex:col pad-tb-90">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-50">

				<div class="block-head">
					<div class="text-tmp title-28"><h2>Актуальные вакансии</h2></div>
				</div>

				{fetch_articles perPage=100 assign=careers image=true section=$section.sectionId typeContent="careers" order="publishedOn DESC" assignPagination=pagination page=$page path=$section.path seFriendly=true sectionInfo=true}

				<div class="grid:fr-3 max g-gap-20">

					{foreach from=$careers item=career}
					<a class="career-card" href="{$SITE_URL}{$career.url}">
						<div class="text-tmp mar-all-10 title-18 txt-12 txt-fw-500">
							<p>Вакансия</p>
							<h3>{$career.title}</h3>
						</div>
						<ul>
							{if !empty($career.practice)}<li>Опыт: {$career.practice}</li>{/if}
							{if !empty($career.alias)}<li>{$career.alias}</li>{/if}
						</ul>
					</a>
					{/foreach}
				</div>

			</div>

		</div>
	</section>

	{* FAQ / Помощь *}
	{fetch_section assign=faqSection section=11}{if $faqSection.status eq 'V'}
	<section class="flex:col pad-tb-90 bg-light-g">
		<div class="flex:col-max">

			{* block FAQ / Помощь *}
			{include file="blocks/block-faq.tpl" name=$faqSection.name}
			{* block FAQ / Помощь *}

		</div>
	</section>
	{/if}
	{* FAQ / Помощь *}

	{* Контакты *}
	{include file="blocks/block-contacts.tpl" classBG="bg-white"}
	{* Контакты *}


</main>

{include file="footer.tpl"}