{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main pad-static">

	{* О компании *}
	<section class="flex:col pad-t-50 pad-b-90">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-30">
				<div class="medium-banner">
					<div class="medium-banner__img">
						{if isset($section.image.original)}
						<img src="{$section.image.original}" alt="{$section.name}">
						{/if}
					</div>

					<div class="medium-banner__info">
						<div class="text-tmp title-44 txt-20 color-white">
							<h1>{$section.name}</h1>
							{$section.content|page_break:0 nofilter}
						</div>
					</div>
				</div>

				<div class="grid:fr-3 max g-gap-30 pad-t-20 bord-t">
					{assign var=contents value=$section.content|break}
					{if is_array($contents)}
						{foreach from=$contents item=content name=contents}{if !$smarty.foreach.contents.first}
							<div class="text-tmp title-44">{$content nofilter}</div>
						{/if}{/foreach}
					{else}
						<div class="text-tmp title-44">{$section.content nofilter}</div>
					{/if}
				</div>
			</div>
		</div>
	</section>
	{* /О компании *}

	{* преимущества *}
	{include file="blocks/block-advantage.tpl"}
	{* /преимущества *}

	{* история *}
	{fetch_section assign=historySection section=35 getContent=true}{if $historySection.status eq 'V'}
	<section class="flex:col pad-tb-50 bg-light-g">
		<div class="history">
			<div class="flex:col-max">
				<div class="text-tmp title-44"><h2>{$historySection.name}</h2></div>
			</div>
			<div class="history__slider-container">
				{fetch_articles perPage=10 assign=historys image=true section=$historySection.sectionId order="publishedOn DESC"}
				<div class="swiper history__slider history-slider_js">
					<div class="swiper-wrapper">
						{foreach from=$historys item=history}
						<div class="swiper-slide" data-year="{$history.title}">
							<div class="history__item">
								<div class="history__item-bg" data-swiper-parallax="200">
									<picture>
										<source srcset="{$history.image.medium}" media="(max-width: 550px)" />
										<source srcset="{$history.image.medium}" media="(max-width: 768px)" />
										<source srcset="{$history.image.original}" media="(max-width: 1024px)" />
										<source srcset="{$history.image.original}" media="(max-width: 1440px)" />
										<img src="{$history.image.original}" alt="{$history.title}" />
									</picture>
								</div>
								<div class="history__item-info">
									<div class="history__item-info-inner">
										<div class="text-tmp title-32 color-white txt-first-20 txt-14 mar-all-10">
											<p>{$history.title}</p>
											<h3>{$history.alias}</h3>
											{$history.summary nofilter}
										</div>
									</div>
								</div>
							</div>
						</div>
						{/foreach}
					</div>
				</div>

				<div class="history__slider-ui">
					<div class="history__pagination"></div>
				</div>
			</div>
		</div>
	</section>
	{/if}
	{* /история *}

	{* наша команда *}
	{fetch_section assign=teamSection section=33 getContent=true}{if $teamSection.status eq 'V'}
	<section class=" flex:col pad-tb-90">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-50">
				<div class="block-head">
					<div class="text-tmp title-44"><h2>{$teamSection.name}</h2></div>
				</div>

				{fetch_articles perPage=100 assign=teams image=true section=$teamSection.sectionId typeContent="teams" order="publishedOn DESC"}
				<div class="grid:fr-1 g-gap-30">

					{assign var=teamItem value=1}
					<div class="grid:fr-2 max g-gap-30">
						{foreach item=team from=$teams name=teams}
							<div class="team-card {$teamItem}">
								<div class="team-card__img"><img src="{$team.image.original}" alt="{$team.title}"></div>
								<div class="team-card__info">
									<div class="text-tmp title-24 txt-fw-500 mar-all-0">
										{if !empty($team.alias)}<p>{$team.alias}</p>{/if}
										<h3>{$team.title}</h3>
									</div>
								</div>
							</div>
						{if $teamItem eq 2}
					</div>
					<div class="grid:fr-3 max g-gap-30">
						{elseif $teamItem eq 5}
					</div>
					<div class="grid:fr-4 max g-gap-30">
						{/if}
						{assign var=teamItem value=$teamItem+1}
						{/foreach}
					</div>
				</div>
			</div>
		</div>
	</section>
	{/if}
	{* /наша команда *}

	{* Организация структуры *}
	{fetch_section assign=structureSection section=36 getContent=true}{if $structureSection.status eq 'V'}
	<section class="flex:col pad-tb-90">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-50">
				<div class="block-head">
					<div class="text-tmp title-44"><h2>{$structureSection.name}</h2></div>
				</div>
				<div class="text-tmp" style="cursor: pointer;" data-modal-src="{$structureSection.image.original}">
					<img src="{$structureSection.image.original}" alt="{$structureSection.name}">
				</div>
			</div>
		</div>
	</section>
	{/if}
	{* /Организация структуры *}

	{* Партнеры *}
	{fetch_section assign=partnerSection section=37 getContent=true}{if $partnerSection.status eq 'V'}
	<section class="flex:col pad-tb-90 bg-light-g">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-50">
				<div class="block-head">
					<div class="text-tmp title-44"><h2>{$partnerSection.name}</h2></div>
				</div>

				<div class="grid:fr-1 g-gap-30">
					{fetch_articles limit=20 assign=partners image=true section=$partnerSection.sectionId order="publishedOn DESC" fields='articleId, title, summary'}
					{foreach from=$partners item=partner name=partners}
					<div class="partners-card-desc {if $smarty.foreach.partners.iteration%2==0}reverse{/if}">
						<div class="partners-card-desc__logo"><img src="{$partner.image.original}" alt="{$partner.title}"></div>
						<div class="partners-card-desc__info">
							<div class="text-tmp">{$partner.summary nofilter}</div>
						</div>
					</div>
					{/foreach}
				</div>
			</div>
		</div>
	</section>
	{/if}
	{* /Партнеры *}

	{* Готовы обсудить *}
	{include file="blocks/block-discuss.tpl"}
	{* /Готовы обсудить *}

</main>


{include file="footer.tpl"}











