{include file="header.tpl" title=$product.title keywords=$product.keywords description=$product.description}

{*{print_r($product)}*}
<main class="main pad-static">

	<section class="flex:col pad-t-50 pad-b-90">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-50">

				<!-- Слайдер и описание -->
				<div class="grid:fr-2 max g-gap-40">
					<div class="grid:fr-1 g-gap-20">
						{if isset($product.gallery) && !empty($product.gallery)}
							<div class="product-sliders">
								<div class="product-slider">
									<div class="swiper product-slider_js">
										<div class="swiper-wrapper">
											{foreach from=$product.gallery item=gallery}
												<div class="swiper-slide">
													<div class="product-slider__item">
														<img src="{$gallery.original}" alt="{$gallery.title}">
													</div>
												</div>
											{/foreach}
										</div>
									</div>
								</div>

								<div class="product-depend-slider">
									<button class="arrow-slider black-theme product-slider-prev_js">
										<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
											<path d="m276.846-460 231.693 231.692L480-200 200-480l280-280 28.539 28.308L276.846-500H760v40H276.846Z" />
										</svg>
									</button>

									<div class="swiper product-depend-slider_js">
										<div class="swiper-wrapper">
											{foreach from=$product.gallery item=gallery}
												<div class="swiper-slide">
													<div class="product-depend-slider__item"><img src="{$gallery.medium}" alt="{$gallery.title}"></div>
												</div>
											{/foreach}
										</div>
									</div>

									<button class="arrow-slider black-theme product-slider-next_js">
										<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
											<path d="M683.154-460H200v-40h483.154L451.461-731.692 480-760l280 280-280 280-28.539-28.308L683.154-460Z" />
										</svg>
									</button>
								</div>
							</div>
						{/if}

					</div>

					<div class="grid:fr-1 g-gap-20">
						<div class="product-desc">
							<div class="text-tmp title-32 txt-18 txt-fw-500 title-fw-500 mar-all-5">
								<h1>{$product.title}</h1>
								{if !empty($product.alias)}<p>{$product.alias}</p>{/if}
							</div>

							<div class="text-tmp title-24 txt-fw-500 mar-all-10">
								{$product.summary nofilter}
							</div>
							{if isset($product.docs)}
								{assign var=doc value=$product.docs|first}
								<a class="btn green-saturated large transparent full" href="{$GLOBAL_URL}{$doc.original}" download>Скачать файл</a>
							{/if}

							<button class="btn green-saturated large full" data-modal-id="modalOreder">Заказать товар</button>
						</div>
					</div>
				</div>

				{* описание таб*}
				<div class="product-txt tab_js">
					<div class="product-txt__btns">
						<button class="product-txt__btn tab-btn_js active">Описание</button>
						{if !empty($product.features)}
						<button class="product-txt__btn tab-btn_js">Характеристики</button>
						{/if}
					</div>

					<div class="product-txt__drops">
						<div class="product-txt__drop tab-drop_js active">
							<div class="text-tmp title-20">{$product.content nofilter}</div>
						</div>
						{if !empty($product.features)}
						<div class="product-txt__drop  tab-drop_js">
							<div class="product-txt__list">
								<ul>
									{foreach from=$product.features item=feature}
									<li><span>{$feature.name}</span><span>{$feature.value}</span></li>
									{/foreach}
								</ul>
							</div>
						</div>
						{/if}
					</div>

				</div>
			</div>
		</div>
	</section>

	{fetch_products limit=8 assign=products image=true section=$product.section.sectionId productId=$product.productId order="publishedOn DESC" typeContent="products"}
	{if !empty($products)}
	<section class="flex:col pad-tb-90 over-hide">
		<div class="flex:col-max">
			<div class="flex:col g-gap-50">
				<div class="block-head">
					<div class="text-tmp title-44"><h2>Схожие товары</h2></div>

					<div class="arrows-wrap">
						<button class="arrow-slider black-theme similar-prev_js">
							<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
								<path d="m276.846-460 231.693 231.692L480-200 200-480l280-280 28.539 28.308L276.846-500H760v40H276.846Z" />
							</svg>
						</button>

						<button class="arrow-slider black-theme similar-next_js">
							<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
								<path d="M683.154-460H200v-40h483.154L451.461-731.692 480-760l280 280-280 280-28.539-28.308L683.154-460Z" />
							</svg>
						</button>
					</div>
				</div>

				<div class="similar-product">
					<div class="swiper similar-product-slider_js">
						<div class="swiper-wrapper">
							{foreach from=$products item=product}
							<div class="swiper-slide">
								{* product item *}
								{include file="items/product.tpl"}
								{* /product item *}
							</div>
							{/foreach}
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	{/if}

</main>

{include file="footer.tpl"}