{strip}
    {fetch_banners assign=banners limit=10 section=$section.sectionId}
    {if !empty($banners)}
		<section class="flex:col">
			<div class="intro">

				<div class="swiper intro-slider_js">
					<div class="swiper-wrapper">
						{foreach item=banner from=$banners name=banners}
						<div class="swiper-slide">
							<div class="intro-banner">

								<div class="intro-banner__bg" data-swiper-parallax="90%">
									<picture>
										<source srcset="{$banner.images.medium}" media="(max-width: 550px)" />
										<source srcset="{$banner.images.medium}" media="(max-width: 768px)" />
										<source srcset="{$banner.images.large}" media="(max-width: 1024px)" />
										<source srcset="{$banner.images.original}" media="(max-width: 1440px)" />
										<img src="{$banner.images.original}" alt="{$banner.title nofilter}" />
									</picture>
								</div>

								<div class="intro-banner__info">
									<div class="flex:col-max">

										<div class="intro-banner__info-desc" data-swiper-parallax="600">

											<div class="text-tmp title-44 color-white mar-all-20">
												{if $smarty.foreach.banners.first}
													<h1>{$banner.title nofilter}</h1>
												{else}
													<h2>{$banner.title nofilter}</h2>
												{/if}
												<p>{$banner.alias nofilter}</p>
											</div>

											{if !empty($banner.url)}
												<a class="btn green-saturated large" href="{$banner.url}">Узнать больше</a>
											{/if}
										</div>
									</div>
								</div>
							</div>
						</div>
						{/foreach}
					</div>
				</div>

				<div class="intro__arrows">
					<div class="flex:col-max-1900">

						<div class="intro__arrows-inner">

							<button class="arrow-slider intro-prev_js">
								<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
									<path d="m276.846-460 231.693 231.692L480-200 200-480l280-280 28.539 28.308L276.846-500H760v40H276.846Z" />
								</svg>
							</button>

							<button class="arrow-slider intro-next_js">
								<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
									<path d="M683.154-460H200v-40h483.154L451.461-731.692 480-760l280 280-280 280-28.539-28.308L683.154-460Z" />
								</svg>
							</button>

						</div>

					</div>
				</div>

			</div>
		</section>
    {/if}
{/strip}