<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>
	{include file="modules/meta.tpl"}
    {include file="modules/link.tpl"}

    <meta name="google-site-verification" content="We4-3GBU1rERvk7MQtxWdGIgHRDJ0IKjGSzigKF4EkE" />
    <meta name="yandex-verification" content="1a055b7f8dcae74c" />
    
</head>

<body>

{fetch_sections assign=headerMenus status="V" topMenu=1 level=1}
<header class="header">
	<div class="flex:col-max">

		<div class="header__inner">

			{logo link=true classLink="logo"}

			<nav class="header__nav">
				<ul>
					{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
					<li><a href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>
					{/foreach}
					{fetch_sections assign=headerSubMenus status="V" topMenu=1 level=2}
					{foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}
						<li><a href="{if !empty($headerSubMenu.externalLink)}{$headerSubMenu.externalLink}{else}{$SITE_URL}{$headerSubMenu.url}{/if}">{$headerSubMenu.alias}</a></li>
					{/foreach}
				</ul>
			</nav>

			<div class="lang">
				<ul>
					<li><a href="{$GLOBAL_URL}/en/">EN</a></li>
					<li><a href="{$GLOBAL_URL}/uz/">UZ</a></li>                    
                    <li><span>RU</span></li>
				</ul>
			</div>

			<button class="burger-btn-cross-deg" data-call-menu>
				<span class="burger-btn__item"></span>
			</button>

		</div>

	</div>

	<div class="header-mob" data-header-mob>

		<div class="header-mob__head">
			<div class="lang">
				<ul>
					<li><span>Ру</span></li>
					<li><a href="{$GLOBAL_URL}/uz/">Узб</a></li>
					<li><a href="{$GLOBAL_URL}/en/">Агл</a></li>
				</ul>
			</div>
		</div>

		<div class="header-mob__inner">

			<div class="header-mob__nav">
				{fetch_sections assign=catalogSections sections=[2, 3, 4, 5] status="V"}
				{foreach item=subcatalog from=$catalogSections name=catalogSections}
				<ul>
					<li>{$subcatalog.alias}</li>
					{fetch_sections assign=headerSubMenus from=$subcatalog.sectionId status="V" level=2}
					{foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}
						<li><a href="{if !empty($headerSubMenu.externalLink)}{$headerSubMenu.externalLink}{else}{$SITE_URL}{$headerSubMenu.url}{/if}">{$headerSubMenu.alias}</a></li>
					{/foreach}
				</ul>
				{/foreach}
			</div>

		</div>

		<div class="header-mob__footer">
			<div class="social">
				{include file="modules/socials.tpl"}
			</div>
		</div>

	</div>

</header>