<div class="d-none">

	{if isset($product)}
	<div class="modal-short" id="modalOreder">

		<div class="text-tmp title-28 mar-all-10 txt-fw-600">
			<h4>Заказать товар</h4>
			<p>{$product.title}</p>
		</div>

		<form class="form validation_js"  action="{$SITE_URL}/ajax-feedback" method="post" id="order">
			{include file="form/captcha.tpl"}
			<div class="input">
				<label for="">Ваше имя</label>
				<input type="text" name="feedback[fullName]" placeholder="Имя" data-empty="Обязательно для заполнения">
			</div>

			<div class="input">
				<label for="">Номер телефона</label>
				<input class="phone_js" type="tel" name="feedback[phone]" placeholder="+998 (00) 000 00 00" data-empty="Обязательно для заполнения">
			</div>

			<input class="not-empty not-valid" type="hidden" name="feedback[subject]"  value="Заказ товара">
			<input class="not-empty not-valid" type="hidden" name="feedback[product]"  value="{$product.title}">
			<button class="btn green-saturated full" type="submit">Отправить <div class="btn__icons"></div></button>
		</form>

	</div>
	{/if}


	<div class="modal-short" id="modalDetails">
		<div class="text-tmp title-28 mar-all-10 txt-fw-600"><h4>Обсудить детали</h4></div>

		<form class="form validation_js" action="{$SITE_URL}/ajax-feedback" method="post" id="feedback">
			{include file="form/captcha.tpl"}
			<div class="input">
				<label for="">Ваше имя</label>
				<input type="text" name="feedback[fullName]" placeholder="Имя" data-empty="Обязательно для заполнения">
			</div>

			<div class="input">
				<label for="">Номер телефона</label>
				<input class="phone_js" type="tel" name="feedback[phone]" placeholder="+998 (00) 000 00 00" data-empty="Обязательно для заполнения">
			</div>

			<input class="not-empty not-valid" type="hidden" name="feedback[subject]"  value="Обсудить детали">
			<button class="btn green-saturated full" type="submit">Отправить <div class="btn__icons"></div></button>
		</form>

	</div>

	{fetch_articles perPage=100 assign=reviews image=true section=43 typeContent="reviews" fields="articleId, title, content"}
	{foreach from=$reviews item=review}
		<div class="modal-review" id="reviewModal_{$review.articleId}">
			<div class="modal-review__inner">

				<div class="modal-review__user">
					<div class="modal-review__user-img"><img src="{$review.image.original}" alt="{$review.title}"></div>
					<div class="text-tmp txt-24 txt-fw-700"><p>{$review.title}</p></div>
				</div>

				<div class="modal-review__info">
					<div class="text-tmp title-20">
						{if isset($review.video_url)}
							<video muted="muted" preload playsinline controls>
								<source src="{$review.video_url}" type="video/mp4">
							</video>
						{/if}

						{$review.content nofilter}
					</div>
				</div>

			</div>
		</div>
	{/foreach}
</div>

<footer class="footer bg-light-g">
	<div class="flex:col-max">

		<div class="footer__inner">

			<div class="footer__content">

				<div class="footer__column">
					{logo link=true classLink="footer__logo" logoUrl="{$ASSETS_URL}/images/icons/logo/logo-vertical.svg"}
					<div class="text-tmp txt-24 txt-fw-600"><p>Let’s build green future</p></div>
				</div>

				<nav class="footer__nav">
					<div class="footer__nav-item">
						{fetch_sections assign=footerMenus sections=[2, 3, 4] status="V" footerMenu=1 level=1}
						{foreach item=footerMenu from=$footerMenus name=footerMenus}
							<ul>
								<li>{$footerMenu.alias}</li>
								{fetch_sections assign=footerSubMenus from=$footerMenu.sectionId status="V" footerMenu=1 level=2}
								{foreach item=footerSubMenu from=$footerSubMenus name=footerSubMenus}
									<li><a href="{if !empty($footerSubMenu.externalLink)}{$footerSubMenu.externalLink}{else}{$SITE_URL}{$footerSubMenu.url}{/if}">{$footerSubMenu.alias}</a></li>
								{/foreach}
							</ul>
						{/foreach}

					</div>

					{fetch_sections assign=footerMenus sections=[5] status="V" footerMenu=1 level=1}
					{foreach item=footerMenu from=$footerMenus name=footerMenus}
					<ul>
						<li>{$footerMenu.alias}</li>
						{fetch_sections assign=footerSubMenus from=$footerMenu.sectionId status="V" footerMenu=1 level=2}
						{foreach item=footerSubMenu from=$footerSubMenus name=footerSubMenus}
							<li><a href="{if !empty($footerSubMenu.externalLink)}{$footerSubMenu.externalLink}{else}{$SITE_URL}{$footerSubMenu.url}{/if}">{$footerSubMenu.alias}</a></li>
						{/foreach}
					</ul>
					{/foreach}
				</nav>

			</div>

			<div class="footer__contact">

				<div class="footer__contact-item">
					<ul>
						<li>Соц.сети</li>
						<li><div class="social">{include file="modules/socials.tpl"}</div></li>
					</ul>
				</div>

				<div class="footer__contact-item">
					<ul>
						<li>E-mail</li>
						<li><a href="mailto:{$config.email}">{$config.email}</a></li>
					</ul>
				</div>

				<div class="footer__contact-item">
					<ul>
						<li>Телефон</li>
						{assign var=phones value=", "|explode:$config.phone}
						{foreach from=$phones item=phone name=phones}
							<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
						{/foreach}
					</ul>
				</div>

				<div class="footer__contact-item">
					<ul>
						<li>Время работы</li>
						<li>{$config.operating_mode}</li>
					</ul>
				</div>

			</div>

			<div class="footer__copy">

				<div class="footer__copy-head">
					<p>© 2023-{$smarty.now|date_format:"%Y"} {$config.website_name}. Все права сайта защищены.</p>
					<ul><li><a href="{$SITE_URL}/privacy-policy/">Политика конфиденциальности</a></li></ul>
				</div>

				<a href="https://www.life-style.uz/" title="Создание и поддержка сайтов в Ташкенте" target="_blank">Создание сайтов <i>Life Style</i></a>
			</div>

		</div>

	</div>
</footer>

<script src="{$ASSETS_URL}/js/vendor/jquery.min.js"></script>
<script src="{$ASSETS_URL}/js/vendor/fancybox.js"></script>
<script src="{$ASSETS_URL}/js/vendor/swiper-bundle.min.js"></script>

<script src="{$ASSETS_URL}/js/main.js{if !$config.compress_js_css}?v{$smarty.now|date_format:"%s"}{/if}"></script>
<script type="module" src="{$ASSETS_URL}/js/moduls/moduls.js" async></script>


{if isset($section) && (in_array($section.sectionId, [1, 2, 3, 5, 6, 7, 8, 14, 15]))}
	<script src="https://api-maps.yandex.ru/2.1/?apikey={$maps.api_key}&lang={$config.website_language}"></script>
	<script type="text/javascript">
        ymaps.ready(init);

        function init() {
            const mapNode = document.querySelector('#map')

            if (window.innerWidth > 1366) {
                if (mapNode) {
                    let createAtention = document.createElement('div')
                    createAtention.classList.add('map-atention')
                    createAtention.textContent = "Для масштабирования карты используйте Shift + Scroll"

                    mapNode.insertAdjacentElement('beforeend', createAtention)
                    mapNode.addEventListener('mouseover', (e) => createAtention.classList.add('hide'))

                    mapNode.addEventListener('mouseleave', (e) => createAtention.classList.remove('hide'))
                }
            }

            let arrCords = [
                [{$maps.coordinates}],
            ]

            let arrText = [
                ["{$config.address}"],
            ]

            var sizeZoom = {$maps.zoom}

            if (window.innerWidth < 768) {
                sizeZoom = 12
            }

            var myMap = new ymaps.Map("map", { center: [{$maps.coordinates}], zoom: sizeZoom, controls: [] }, { suppressMapOpenBlock: true }),
                myGeoObject = new ymaps.GeoObject();

            if (window.innerWidth > 1366) {
                myMap.behaviors.disable('scrollZoom');
                myMap.events.add('wheel', function (e) {
                    if (e.get('shiftKey')) {
                        var delta = e.get('delta');
                        var newZoom = myMap.getZoom() + (delta > 0 ? 1 : -1);
                        myMap.setZoom(newZoom, {
                            checkZoomRange: true
                        });
                    }
                });
            }

            for (let index = 0; index < arrCords.length; index++) {
                const element = arrCords[index];
                const text = arrText[index];

                myMap.geoObjects.add(myGeoObject).add(new ymaps.Placemark([element[0], element[1]],
                    { balloonContentHeader: text[0], balloonContentBody: text[1],},
                    { preset: 'islands#icon', iconCaptionMaxWidth: '30', iconColor: '#0e1f31',}
                )).events
                    .add('balloonopen', function (e) {
                        e.get('target').options.set('iconImageHref', 'images/icon/baloon2.png');
                    })
                    .add('balloonclose', function (e) {
                        e.get('target').options.set('iconImageHref', 'images/icon/baloon.png');
                    });
            }
        }
	</script>
{/if}

{if isset($config.yandex_metrika) && !empty($config.yandex_metrika)}
    {yandex_metrika code=$config.yandex_metrika}
{/if}
{if isset($config.google_analytics) && !empty($config.google_analytics) }
    {google_analytics code=$config.google_analytics}
{/if}


</body>

</html>


