export const form = () => {
    let discuss = new Validations('#discuss'),
        order = new Validations('#order'),
        career = new Validations('#career'),
        feedback = new Validations('#feedback')

    discuss.request((form) => {
        const formCurrent = $(`#${form.id}`),
            formAction = form.action,
            formMethod = form.method

        $.ajax({
            url: formAction,
            type: formMethod,
            data: formCurrent.serialize(),
            beforeSend: function () {
                new CreatePreloader(form.id)
            },
            success: function (response) {
                new RemovePreloader(form.id, response.message, response.status)
            },
            error: function (response) {
                new RemovePreloader(form.id, response.statusText + ' ' + response.responseText, response.status)
            },
            complete: function () {},
        })
    })

    order.request((form) => {
        const formCurrent = $(`#${form.id}`);

        $.ajax({
            url:  formCurrent.attr("action"),
            type: formCurrent.attr("method"),
            data: formCurrent.serialize(),
            beforeSend: function () {
                new CreatePreloader(form.id)
            },
            success: function (response) {
                new RemovePreloader(form.id, response.message, response.status)
            },
            error: function (response) {
                new RemovePreloader(form.id, response.statusText + ' ' + response.responseText, response.status)
            },
            complete: function () {},
        })
    })

    career.request((form) => {
        const formCurrent = $(`#${form.id}`);
        let formData = new FormData(document.getElementById("career"));
        $.ajax({
            url: formCurrent.attr("action"),
            type: formCurrent.attr("method"),
            data: formData,
            contentType: false,
            processData: false,
            beforeSend: function () {
                new CreatePreloader(form.id)
            },
            success: function (response) {
                new RemovePreloader(form.id, response.message, response.status)
            },
            error: function (response) {
                new RemovePreloader(form.id, response.statusText + ' ' + response.responseText, response.status)
            },
            complete: function () {},
        })
    })

    feedback.request((form) => {
        const formCurrent = $(`#${form.id}`),
            formAction = form.action,
            formMethod = form.method

        $.ajax({
            url: formAction,
            type: formMethod,
            data: formCurrent.serialize(),
            beforeSend: function () {
                new CreatePreloader(form.id)
            },
            success: function (response) {
                new RemovePreloader(form.id, response.message, response.status)
            },
            error: function (response) {
                new RemovePreloader(form.id, response.statusText + ' ' + response.responseText, response.status)
            },
            complete: function () {},
        })
    })
}
