<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

function smarty_function_fetch_projects($params, &$smarty) {
	global $fetchedProjects;

	$assign        = fetch_getParam('assign', $params, 'projects');
	$fields        = fetch_getParam('fields', $params, 'projectId, sectionId, orderBy, publishedOn, title, alias, url, summary, isFeatured, orderBy, typeContent');
	$status        = fetch_getParam('status', $params, 'V');
	$limit         = (int) fetch_getParam('limit', $params);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);
	$isFeatured    = fetch_getParam('isFeatured', $params, NULL);
	
	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);
	$section       = fetch_getParam('section', $params);
	$company       = fetch_getParam('company', $params);
    $projectId     = fetch_getParam('projectId', $params);
	$page          = (int) fetch_getParam('page', $params);
	$skip          = fetch_getParam('skip', $params, NULL);
	$noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);

	$image        = fetch_getParam('image', $params, false);
	$imageType    = fetch_getParam('imageType', $params, 'general');

	$sectionInfo  = fetch_getParam('sectionInfo', $params, false);
	$parentsInfo  = fetch_getParam('parentsInfo', $params, false);
	
	$assignPagination = fetch_getParam('assignPagination', $params);
	$path             = fetch_getParam('path', $params);
	$seFriendly       = (boolean) fetch_getParam('seFriendly', $params);
	$pnFirst          = (int) fetch_getParam('pnFirst', $params, 0);
	$pnBefore         = (int) fetch_getParam('pnBefore', $params, 4);
	$pnAfter          = (int) fetch_getParam('pnAfter', $params, 4);
	$pnLast           = (int) fetch_getParam('pnLast', $params, 0);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_articles: "assign" must not be empty');
		return;
	}
	
	if (empty($path)) $path = array();

    /** calculate article popularity article fields */
//    fetch_projects_calculatePopularity($orderBy);

	/** conditions */
    filterProject($status, $isFeatured, $projectId, $orderBy, $query, $company);

    if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

    /** query conditions */
    fetch_projects_addQueryConditions($query, $match, $fields, $orderBy);
    /** add section conditions */
    fetch_projects_addSectionConditions($section, $noSubsections);
    /** skipping articles */
//    fetch_articles_addSkipConditions($skip);
    /** checking article fields */
    fetch_projects_filterFields($fields);

	if ($page < 1) $page = 1;
	if ($perPage < 1) $perPage = 10;

	if (!is_null($query) && empty($query)) {
		$projects = array();
	} else {
        $projects = connect('projects')->select($fields)->pagination($perPage, $page)->getAll('array');
//            print_r(connect()->getQuery());
        $projects = prepareProjects($projects, $sectionInfo, $parentsInfo, $image, $imageType);
	}

//	print_r($projects);
	$smarty->assign($assign, $projects);

	/* saving fetched articles for SKIP ability */
	if(empty($fetchedProjects[$assign])) $fetchedProjects[$assign] = array();
	if(!empty($articles)) foreach ($articles as $article) $fetchedProjects[$assign][] = $article['projectId'];
	
	if (!empty($assignPagination)) {

        /** calculate article popularity article fields */
        fetch_projects_calculatePopularity($orderBy);

        /** conditions */
        filterProject($status, $isFeatured, $projectId, $orderBy, $query, $company);

        if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

        /** query conditions */
        fetch_projects_addQueryConditions($query, $match, $fields, $orderBy);
        /** add section conditions */
        fetch_projects_addSectionConditions($section, $noSubsections);
        /** skipping articles */
        fetch_projects_addSkipConditions($skip);
        /** checking article fields */
        fetch_projects_filterFields($fields);

        /** page numbering */
        $total = connect('projects')->countDistinct('projectId')->getValue();
		if (is_array($path)) {
			$path = SITE_URL.'/'.basename($_SERVER['PHP_SELF']).'?'.(!empty($path) ? implode('&', $path).'&' : '');
			$seFriendly = false;
		}
		$pagination = getPageNums($total, $page, $perPage, $pnFirst, $pnBefore, $pnAfter, $pnLast, $path, $seFriendly);
		$smarty->assign($assignPagination, $pagination);
	}
	
	return null;
}

function filterProject($status, $isFeatured, $projectId, $orderBy, $query, $company)
{
    global $gmNow;

    connect()->where('publishedOn','<=', $gmNow);
    if (!empty($status)) connect()->where('status', $status);
    if (!is_null($isFeatured)) connect()->where('isFeatured',$isFeatured ? 1 : 0);
    if (!empty($projectId)) connect()->where('projectId', '!=', $projectId);
    if (!empty($company)) connect()->where('companyId', $company);
    if (is_null($orderBy)) {
        connect()->orderBy(is_null($query) ? 'publishedOn DESC' : '');
    } else {
        connect()->orderBy($orderBy);
    }
}

?>