<?php

namespace Mnv\Modules;

use Mnv\Core\Utilities\Cookie\Cookie;

class Stock
{

    private $isStock = false;

    /**
     * Конструктор класса
     */
    public function __construct()
    {
        $this->load();
    }

    /**
     * Добавление/удаление новости в закладки
     * @param bool $isStock
     */
    public function set(bool $isStock = false)
    {
        Cookie::setcookie('_stock', $isStock, \time() + 3600 * 24 * 1000, "/");
    }

    /**
     * Получение списка закладок
     * @return void
     */
    private function load()
    {
        $this->isStock = Cookie::get('_stock');
    }
}