<?php

namespace Mnv\Modules\Shop;

use Mnv\Core\Utilities\Base64\Base64;
use Mnv\Core\Utilities\Cookie\Session;

/**
 * Class Helpers
 * @package Mnv\Modules\Shop
 */
class Helpers
{

    /** Формирование номера телефона */
    public function formatPhoneNumber($phone): ?string
    {
        $phone = preg_replace('/[^0-9]/', '', $phone);
        return preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $phone);
    }

    /** Формат цены */
    public static function priceFormat($price)
    {
        if (Session::get('currency') == 'UZS') {
            return number_format($price, 0, '.', ' ') . ' сум';
        } else {
            return number_format($price, 2, '.', ' ') . ' $';
        }
    }

    /** Формат цены */
    public static function price_format($price, bool $format = true)
    {
        global $activeCurrency;

        $result = ((int)$price * $activeCurrency['course']);
        if ($format) $result = number_format($result, $activeCurrency['cent'], '.', $activeCurrency['thousands_separator']);

        if ($activeCurrency['codeName'] == '$' || $activeCurrency['codeName'] == '€') {
            $result = $activeCurrency['codeName'] . '' . $result;
        } else {
            $result = $result . ' ' . $activeCurrency['codeName'];
        }

        return $result;
    }



    /**
     * @param $price
     * @return array|string|string[]|null
     */
    public static function integerFormat($price)
    {
        $price = filter_var($price, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
        return str_replace(".", ',', $price);
    }

    /**
     * @param int|null $maxLength
     * @return string
     * @throws \Mnv\Core\Utilities\Base64\Throwable\EncodingError
     */
    public static function createRandomString(?int $maxLength = 24): string
    {
        // вычислить, сколько байтов случайности нам нужно для указанной длины строки
        $bytes = \floor((int) $maxLength / 4) * 3;

        // получить случайные данные
        $data = \openssl_random_pseudo_bytes($bytes);

        // вернуть результат в кодировке Base64
        return Base64::encodeUrlSafe($data);
    }

    /**
     * @param int|null $length
     * @return false|string
     */
    public static function generateRandomString(?int $length = 10)
    {
        return substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length/strlen($x)) )),1,$length);
    }

    public function firstElement($params = array())
    {
        if(!is_array($params))
            return false;
        return reset($params);
    }

}