<?php
namespace Mnv\Modules\Payment\Upay\Form;

use Mnv\Modules\Payment\PaymentMethodService;
use Mnv\Modules\Payment\PaymentMethodInterface;

final class UpayGenerationForm implements PaymentMethodInterface
{
    const CALLBACK = SITE_URL.'/callback/';
    private $ACCOUNT;
    private $SERVICE;

    public function __construct()
    {
        $payment = new PaymentMethodService('upay');
        $this->ACCOUNT = $payment->payment_method['settings']['merchant'];
        $this->SERVICE = $payment->payment_method['settings']['service'];
    }

    public function form($payment): ?string
	{
		if (!$payment['order_id']) return null;

		$button = '<button type="submit" value="Оплатить через UPAY"></button>';
		if ($payment['auto']) {
			$auto   = '<script type="text/javascript">upay.submit()</script>';
			$button = '';
		}

		$fields = $this->fields($payment);

		return <<<HTML
<form action="https://pay.smst.uz/prePay.do" method="post" name="upay" target="_blank">
<h4>Пожертвования</h4>
 <label>$payment[order_id]</label>
{$fields}
{$button}
</form>
{$auto}
HTML;

	}

    public function fields($payment): string
	{

		$fields = array(
			'personalAccount'   => $this->ACCOUNT,  // Аккаунт или Id номер за который поизводиться оплата
			'serviceId'         => $this->SERVICE,  //  Уникальный номер услуги в системе UPAY
			'amount'            => $payment['amount'],         // Сумма оплаты
			'apiVersion'        => 1,               // Версия UPAY = 1
			'callback'          => SITE_URL,

		);

		$html = '';

		foreach ($fields as $field => $val) {
			$html .= '<input type="hidden" name="' . $field . '" value="' . $val . '" />' . PHP_EOL;
		}
		return $html;
	}
}

/*
<form action="https://pay.smst.uz/prePay.do" target="_blank" method="POST">
 <h4>Пополнить баланс</h4>
 <label>Идентификационный номер</label>
 <input name="personalAccount" type="text" /> <!-- Аккаунт или Id номер за который поизводиться оплата -->

 <label>Сумма платежа</label>
 <input name="amount" type="text" />   <!-- Сумма оплаты -->
 <input name="serviceId" value="8" type="hidden" />  <!-- Уникальный номер услуги в системе UPAY -->
 <input name="apiVersion" value="1" type="hidden" /> <!-- Версия UPAY = 1 -->
 <input type="submit" value="Оплатить через UPAY" />
 </form>
*/




