<?php

namespace Mnv\Http\Client;

/**
 * Class RequestException
 * @package Mnv\Http\Client
 */
class RequestException extends HttpClientException
{
    /**
     * The response instance.
     *
     * @var \Mnv\Http\Client\Response
     */
    public $response;

    /**
     * Create a new exception instance.
     *
     * @param  \Mnv\Http\Client\Response  $response
     * @return void
     */
    public function __construct(Response $response)
    {
        parent::__construct("HTTP request returned status code {$response->status()}.", $response->status());

        $this->response = $response;
    }
}
