<?php


namespace Mnv\Core\Interfaces;


use Mnv\Models\Users\UserSettingOption;

class AdminUiList extends AdminList
{

    public function AddHeaders($aParams)
    {
        parent::AddHeaders($aParams);
        $this->setVisibleHeaderColumn();
    }

    public function setVisibleHeaderColumn()
    {
        $gridOptions = new UserSettingOption($this->table_id, $this->managerId);
        $gridColumns = $gridOptions->getVisibleColumns();
        if ($gridColumns)
        {
            $this->arVisibleColumns = array();
            $this->aVisibleHeaders = array();
            foreach ($gridColumns as $columnId) {
                if (isset($this->aHeaders[$columnId]) && !isset($this->aVisibleHeaders[$columnId])) {
                    $this->arVisibleColumns[] = $columnId;
                    $this->aVisibleHeaders[$columnId] = $this->aHeaders[$columnId];
                }
            }
        }
    }

//    public function displayTable($arParams = array(), $pages, int $page, $buildQueryString)
//    {
//        $arParams = array_change_key_case($arParams, CASE_UPPER);
//
//
//        $errorMessages = [];
//
//        echo $this->sPrologContent;
//
//        $selfFolderUrl = (defined("SELF_FOLDER_URL") ? SELF_FOLDER_URL : "/bitrix/admin/");
//
//        $this->showContext();
//
//        $gridParameters = array(
//            "GRID_ID"               => $this->table_id,
//            "AJAX_MODE"             => "Y",
//            "AJAX_OPTION_JUMP"      => "N",
//            "AJAX_OPTION_HISTORY"   => "N",
//            "SHOW_PAGESIZE"         => true,
//            "AJAX_ID"               => CAjax::getComponentID("bitrix:main.ui.grid", ".default", ""),
//            "ALLOW_PIN_HEADER"      => true,
//            "ALLOW_VALIDATE"        => false,
//            "HANDLE_RESPONSE_ERRORS" => true
//        );
//
//        $actionPanel = ($arParams["ACTION_PANEL"] ?? $this->getGroupAction());
//        if ($actionPanel) {
//            $gridParameters["ACTION_PANEL"] = $actionPanel;
//        } else {
//            $gridParameters["SHOW_CHECK_ALL_CHECKBOXES"] = false;
//            $gridParameters["SHOW_ROW_CHECKBOXES"] = false;
//            $gridParameters["SHOW_SELECTED_COUNTER"] = false;
//            $gridParameters["SHOW_ACTION_PANEL"] = false;
//        }
//
//        if (isset($arParams["SHOW_TOTAL_COUNTER"])) {
//            $gridParameters["SHOW_TOTAL_COUNTER"] = $arParams["SHOW_TOTAL_COUNTER"];
//        }
//
//        $showTotalCountHtml = (isset($arParams["SHOW_COUNT_HTML"]) && $arParams["SHOW_COUNT_HTML"] === true);
//        if ($showTotalCountHtml) {
//            $gridParameters["TOTAL_ROWS_COUNT_HTML"] = $this->getTotalRowsCountHtml();
//        }
//
//        $gridOptions = new UserSettingOption($gridParameters["GRID_ID"], $this->managerId);
//        $gridColumns = $gridOptions->getVisibleColumns();
//        $defaultSort = array();
//        if ($this->sort instanceof AdminSorting) {
//            $defaultSort = array("sort" => array($this->sort->getField() => $this->sort->getOrder()));
//        }
//        $sorting = $gridOptions->GetSorting($defaultSort);
//        $gridParameters["SORT"] = $sorting["sort"];
//        $gridParameters["SORT_VARS"] = $sorting["vars"];
//
//        $gridColumns = $gridOptions->getVisibleColumns();
//        if (empty($gridColumns))
//            $gridColumns = array_keys($this->aVisibleHeaders);
//
//        $gridParameters["ENABLE_NEXT_PAGE"] = $this->enableNextPage;
//        $gridParameters["TOTAL_ROWS_COUNT"] = $this->totalRowCount;
//        if ($this->sNavText) {
//            $gridParameters["NAV_STRING"] = $this->sNavText;
//        } else {
//            $gridParameters["SHOW_PAGINATION"] = false;
//        }
//
//
//        $gridParameters["ROWS"] = array();
//        /** @var \AdminUiListRow $row */
//        foreach ($this->aRows as $row) {
//            $gridRow = array("id" => $row->id, "actions" => $row->getPreparedActions());
//
//            $gridRow["default_action"] = array();
//            if ($row->title) {
//                $gridRow["default_action"]["title"] = $row->title;
//            }
//            $defaultActionType = $row->getConfigValue(CAdminUiListRow::DEFAULT_ACTION_TYPE_FIELD);
//            switch ($defaultActionType) {
//                case CAdminUiListRow::LINK_TYPE_SLIDER:
//                    $skipUrlModify = $row->getConfigValue(CAdminUiListRow::SKIP_URL_MODIFY_FIELD) === true ? 'true' : 'false';
//                    $gridRow["default_action"]["onclick"] = "BX.adminSidePanel.onOpenPage('".$row->link."', ".$skipUrlModify.");";
//                    break;
//                case CAdminUiListRow::LINK_TYPE_URL:
//                    $gridRow["default_action"]["href"] = htmlspecialcharsback($row->link);
//                    break;
//                default:
//                    if ($arParams["DEFAULT_ACTION"]) {
//                        if ($this->isPublicMode) {
//                            if (!empty($row->link)) {
//                                $row->link = str_replace("/bitrix/admin/", $selfFolderUrl, $row->link);
//                            }
//                        }
//                        $gridRow["default_action"]["href"] = htmlspecialcharsback($row->link);
//                    } elseif ($row->link) {
//                        if ($this->isPublicMode) {
//                            $skipUrlModificationEnabled = ($arParams['SKIP_URL_MODIFICATION'] ?? false) === true;
//                            $skipUrlModification = $skipUrlModificationEnabled && mb_strpos($row->link, '/bitrix/admin/') === false ? 'true' : 'false';
//                            $gridRow["default_action"]["onclick"] = "BX.adminSidePanel.onOpenPage('".$row->link."', ".$skipUrlModification.");";
//                        } else {
//                            $gridRow["default_action"]["href"] = htmlspecialcharsback($row->link);
//                        }
//                    } else {
//                        $gridRow["default_action"]["onclick"] = "";
//                    }
//                    break;
//            }
//
//            foreach ($row->aFields as $fieldId => $field) {
//                if (!empty($field["edit"]["type"]))
//                    $this->SetHeaderEditType($fieldId, $field);
//            }
//
//            $listEditable = array();
//            foreach (array_diff_key($this->aHeaders, $row->aFields) as $fieldId => $field) {
//                $listEditable[$fieldId] = false;
//            }
//
//            $disableEditColumns = array();
//
//            foreach ($gridColumns as $columnId) {
//                $value = '';
//                $field = [];
//                if (isset($row->aFields[$columnId])) {
//                    $field = $row->aFields[$columnId];
//                }
//                if (isset($row->arRes[$columnId])) {
//                    if (!is_array($row->arRes[$columnId])) {
//                        $value = trim($row->arRes[$columnId]);
//                    } else {
//                        $value = $row->arRes[$columnId];
//                    }
//                }
//
//                $editValue = $value;
//                if (isset($field["edit"]["type"])) {
//                    switch ($field["edit"]["type"]) {
//                        case "file":
//                            if ($fileArray = CFile::getFileArray($value))
//                                $editValue = $fileArray["SRC"];
//                            break;
//                        case "html":
//                            $editValue = $field["edit"]["value"];
//                            break;
//                        case "money":
//                            $moneyAttributes = $field["edit"]["attributes"];
//                            $editValue = [
//                                'PRICE' => $moneyAttributes['PRICE'],
//                                'CURRENCY' => $moneyAttributes['CURRENCY'],
//                                'ATTRIBUTES' => $moneyAttributes['ATTRIBUTES'],
//                            ];
//
//                            if (is_array($moneyAttributes['HIDDEN'])) {
//                                $editValue['HIDDEN'] = [];
//                                foreach ($moneyAttributes['HIDDEN'] as $hiddenItem) {
//                                    $editValue['HIDDEN'][$hiddenItem['NAME']] = $hiddenItem['VALUE'];
//                                }
//                            }
//                            break;
//                    }
//                } else {
//                    $disableEditColumns[$columnId] = false;
//                }
//
//                $gridRow["data"][$columnId] = $editValue;
//
//                if (isset($field["view"]["type"])) {
//                    switch ($field["view"]["type"]) {
//                        case "checkbox":
//                            if ($value == "Y")
//                                $value = htmlspecialcharsex(GetMessage("admin_lib_list_yes"));
//                            else
//                                $value = htmlspecialcharsex(GetMessage("admin_lib_list_no"));
//                            break;
//                        case "select":
//                            if (isset($field["edit"]["values"][$value])) {
//                                $value = htmlspecialcharsex($field["edit"]["values"][$value]);
//                            } elseif (isset($field["view"]["values"][$value])) {
//                                $value = htmlspecialcharsex($field["view"]["values"][$value]);
//                            }
//                            break;
//                        case "file":
//                            $value = $value ? CFileInput::Show("fileInput_".$value, $value,
//                                $field["view"]["showInfo"], $field["view"]["inputs"]) : "";
//                            break;
//                        case "html":
//                            $value = $field["view"]["value"];
//                            break;
//                        default:
//                            $value = htmlspecialcharsex($value);
//                            break;
//                    }
//                } else {
//                    $value = htmlspecialcharsbx($value);
//                }
//
//                $gridRow["columns"][$columnId] = $value;
//            }
//            $gridRow["editable"] = $listEditable;
//            if (!empty($disableEditColumns))
//                $gridRow["editableColumns"] = $disableEditColumns;
//
//            $gridParameters["ROWS"][] = $gridRow;
//        }
//
//        $gridParameters["COLUMNS"] = array();
//        foreach ($this->aHeaders as $header) {
//            $header["name"] = $header["content"];
//            $gridParameters["COLUMNS"][] = $header;
//        }
//
//        if (!empty($errorMessages)) {
//            $gridParameters["MESSAGES"] = $errorMessages;
//        }
//
//        echo $this->sEpilogContent;
//
//        $jsParams = [];
//        $jsParams["publicMode"] = $this->isPublicMode;
//        $jsParams["showTotalCountHtml"] = $showTotalCountHtml;
//        $jsParams["serviceUrl"] = ($arParams["SERVICE_URL"] ?? "");
//    }
}