<?php


namespace Mnv\Core;

/**
 * Class Helpers
 * @package Mnv\Core
 */
class Helpers
{

    /**
     * @return array
     */
    public static function getThemes(): array
    {
        $dh = opendir(GLOBAL_ROOT.'/themes');
        while ($item = readdir($dh)) {
            if ($item != '.' && $item != '..' && $item != 'assets' && is_dir(GLOBAL_ROOT . "/themes/$item")) {
                $themes[] = $item;
            }
        }
        sort($themes);
        closedir($dh);

        return $themes;
    }

    /**
     * Блокировка не желательных пользователей (или взломщиков)
     *
     * @param $visitorIp
     * @return string|null
     */
    public static function dieIfBanned($visitorIp): ?string
    {
        $result = null;
        if ($ban = connect()->table('users_banned_ips')->where('visitorIp', $visitorIp)->get()) {
            if (strtotime($ban->expiresOn) <= time()) {
                connect()->table('users_banned_ips')->where('visitorIp', $ban->visitorIp)->delete();
            } else {
                $result = "Your IP has been banned until $ban->expiresOn.";
            }
        }

        return $result;
    }

    /**
     * @param int $skipId
     * @param int $maxDepth
     * @param string $prefix
     * @param string $separator
     * @return array
     */
    public static function getAllSectionOptions(int $skipId = 0, int $maxDepth = 99, $prefix = '', $separator = ' :: '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) {
            return array();
        }

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section['sectionId'] == $skipId) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            if (!empty($section['parents'])) {
                foreach ($section['parents'] as $parentId) {
                    if (!empty($SECTIONS[$parentId])) {
                        $option .= $separator;
//                        $option .= $SECTIONS[$parentId]['name'] . $separator;
                    }
                }
            }
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) == 1) return array();

        return $options;
    }

    /**
     * @param int $skipId
     * @param int $maxDepth
     * @param string $prefix
     * @param string $separator
     * @return array
     */
    public static function getSectionOptions(int $skipId = 0, int $maxDepth = 99, $prefix = '', $separator = ' :: '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) {
            return array();
        }

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section['type'] == 'plain') {
                continue;
            }
            if ($section['sectionId'] == $skipId) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            if (!empty($section['parents'])) {
                foreach ($section['parents'] as $parentId) {
                    if (!empty($SECTIONS[$parentId])) {
                         $option .= $separator;
//                         $option .= $SECTIONS[$parentId]['name'] . $separator;
                    }
                }
            }
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) == 1) {
            return array();
        }

        return $options;
    }

    /**
     * @param int|null $skipId
     * @param string|null $typeContent
     * @param int|null $maxDepth
     * @param string|null $separator
     * @return array
     */
    public static function getSectionContent(?int $skipId, ?string $typeContent, ?int $maxDepth = 99, ?string $separator = ' :: '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array('' => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section['type'] == 'plain') {
                continue;
            }
            if ($section['sectionId'] == $skipId || (!is_null($typeContent) && $section['typeContent'] != $typeContent)) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            if (!empty($section['parents'])) {
                foreach ($section['parents'] as $parentId) {
                    if (!empty($SECTIONS[$parentId])) {
                        $option .= $separator;
//                         $option .= $SECTIONS[$parentId]['name'] . $separator;
                    }
                }
            }
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) == 1) {
            return array();
        }

        return $options;
    }

    /**
     * @param int|null $skipId
     * @param string|null $typeContent
     * @param int|null $maxDepth
     * @param string|null $separator
     * @return array
     */
    public static function getMultiSectionContent(?int $skipId, ?string $typeContent, ?int $maxDepth = 99, ?string $separator = ' :: '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array();
        foreach ($SECTIONS as $section) {
            if ($section['type'] == 'plain') {
                continue;
            }
            if ($section['sectionId'] == $skipId || (!is_null($typeContent) && $section['typeContent'] != $typeContent)) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            if (!empty($section['parents'])) {
                foreach ($section['parents'] as $parentId) {
                    if (!empty($SECTIONS[$parentId])) {
                        $option .= $separator;
//                         $option .= $SECTIONS[$parentId]['name'] . $separator;
                    }
                }
            }
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) == 1) {
            return array();
        }

        return $options;
    }


    /**
     * @param int|null $skipId
     * @param string|null $typeContent
     * @param int|null $maxDepth
     * @param string|null $separator
     * @return array
     */
    public static function getSectionBlock(?int $skipId, ?int $maxDepth = 99, ?string $separator = ' :: '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section['sectionId'] == $skipId) {
                if (!empty($section['allChildren'])) {
                    $skipChildren = $section['allChildren'];
                }
                continue;
            }
            if (in_array($section['sectionId'], $skipChildren, true)) {
                continue;
            }
            if ($section['level'] > $maxDepth) {
                continue;
            }

            $option = '';
            if (!empty($section['parents'])) {
                foreach ($section['parents'] as $parentId) {
                    if (!empty($SECTIONS[$parentId])) {
                        $option .= $separator;
//                         $option .= $SECTIONS[$parentId]['name'] . $separator;
                    }
                }
            }
            $option .= $section['name'];
            $options[$section['sectionId']] = $option;
        }

        if (count($options) == 1) {
            return array();
        }

        return $options;
    }

}