<?php


namespace Mnv\Core;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use PhpOffice\PhpSpreadsheet\Writer\Exception;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class ExportService
{
    public function exportExcel(string $typeFile, $postResult)
    {
        $spreadsheet = new Spreadsheet();
        $spreadsheet->getProperties()->setTitle("Проекты и клиенты");
        $spreadsheet->setActiveSheetIndex(0);
        $sheet = $spreadsheet->getActiveSheet();

        $sheet->SetCellValue('A1', 'ID');
        $sheet->SetCellValue('B1', 'START DATE');
        $sheet->SetCellValue('C1', 'END DATE');
        $sheet->SetCellValue('D1', 'NAME');
        $sheet->SetCellValue('E1', 'CATEGORY');
        $sheet->SetCellValue('F1', 'DOMAIN');
        $sheet->SetCellValue('G1', 'TRELLO');
        $sheet->SetCellValue('H1', 'CLIENT F.I.O.');
        $sheet->SetCellValue('I1', 'CLIENT TELEGRAM');
        $sheet->SetCellValue('J1', 'CLIENT EMAIL');
        $sheet->SetCellValue('K1', 'CLIENT TELEPHONE');
        $sheet->SetCellValue('L1', 'ORDER STATUS');
        $sheet->SetCellValue('M1', 'TYPE WORK');
//        $sheet->SetCellValue('N1', 'PRICES (название: сумма: дата: процент)');
        $sheet->getStyle("A1:M1")->getFont()->setBold(true);
        $rowCount = 2;
        if (! empty($postResult)) {
            foreach ($postResult as $k => $v) {
                $A = $sheet->setCellValue("A" . $rowCount, $postResult[$k]["projectId"]);
                $A->getStyle('A')->getFont()->setBold(true);
                $A->getColumnDimension("A")->setAutoSize(TRUE);
                $sheet->setCellValue("B" . $rowCount, $postResult[$k]["publishedOn"] ?? '')->getColumnDimension("B")->setAutoSize(TRUE);
                $sheet->setCellValue("C" . $rowCount, $postResult[$k]["publicationEnd"] ?? '')->getColumnDimension("C")->setAutoSize(TRUE);
                $sheet->setCellValue("D" . $rowCount, $postResult[$k]["title"])->getColumnDimension("D")->setAutoSize(TRUE);
                $sheet->setCellValue("E" . $rowCount, $postResult[$k]["category"])->getColumnDimension("E")->setAutoSize(TRUE);
                $sheet->setCellValue("F" . $rowCount, $postResult[$k]["domain"] ?? '')->getColumnDimension("F")->setAutoSize(TRUE);
                $sheet->setCellValue("G" . $rowCount, $postResult[$k]["trello"] ?? '')->getColumnDimension("G")->setAutoSize(TRUE);
                $sheet->setCellValue("H" . $rowCount, $postResult[$k]["fullName"] ?? '')->getColumnDimension("H")->setAutoSize(TRUE);
                $sheet->setCellValue("I" . $rowCount, $postResult[$k]["telegram"] ?? '')->getColumnDimension("I")->setAutoSize(TRUE);
                $sheet->setCellValue("J" . $rowCount, $postResult[$k]["email"] ?? '')->getColumnDimension("J")->setAutoSize(TRUE);
                $sheet->setCellValue("K" . $rowCount, $postResult[$k]["phone"] ?? '')->getColumnDimension("K")->setAutoSize(TRUE);
                $sheet->setCellValue("L" . $rowCount, $postResult[$k]["state"])->getColumnDimension("L")->setAutoSize(TRUE);
                $sheet->setCellValue("M" . $rowCount, $postResult[$k]["type_work"])->getColumnDimension("N")->setAutoSize(TRUE);
//                $sheet->setCellValue("N" . $rowCount, $postResult[$k]["payments"] ?? null)->getColumnDimension("N")->setAutoSize(TRUE);

                $rowCount ++;
            }
//            $sheet->getStyle('A:F')->getFont()->setBold(true);
//            $sheet->getStyle('A:F')->getFont()->setBold(true);
            $sheet->getStyle('A:F')->getAlignment()->setWrapText(false)->setHorizontal(Alignment::HORIZONTAL_LEFT);
            $sheet->getRowDimension($rowCount)->setRowHeight(30);
        }

        $fileName = '';
        $writer = '';
        if ($typeFile == 'xlsx') {
            $fileName = 'projects_' . time() . '.xlsx';
            $writer = new Xlsx($spreadsheet);
        }

        if ($typeFile == 'xls') {
            $fileName = 'projects_' . time() . '.xls';
            $writer = new Xls($spreadsheet);
        }

        if ($typeFile == 'csv') {
            $fileName = 'projects_' . time() . '.csv';
            $writer = new Csv($spreadsheet);
        }

        try {
            ob_end_clean();
            $writer->save( '../download/' . $fileName);
        } catch (Exception $e) {
            print_r($e->getMessage());
        }

//        $headers = [
//            'Content-Type' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
//            'Content-Length' => filesize('../' . $fileName),
//            'Content-Transfer-Encoding' => 'binary',
//            'Cache-Control' => 'must-revalidate',
//            'Pragma' => 'public',
//        ];
        response()->download('../download/' . $fileName, $fileName, [], 'attachment')->send();
//print_r($result);
        exit;
    }
}