
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary" id="addbutton" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="javascript:void('');"><i class="icon-plus3"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/translations" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}

{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<!-- Content area -->
<div class="content">
	<div class="card border shadow-sm">
		<table class="table table-striped translations-list" id="translations">
			<thead>
			<tr>
				<th class="text-left">Index</th>
				<th class="text-left">Variable</th>
				<th class="text-left">Value</th>
				<th class="text-left">Action</th>
			</tr>
			</thead>
		</table>
	</div>
</div>


<script>


    var LangList = function() {


        // Datatable
        var _componentDatatable = function() {
            if (!$().DataTable) {
                console.warn('Warning - datatables.min.js is not loaded.');
                return;
            }
            var columnDefs = [
                { data: "index", defaultContent:"", width: '5%',  targets: 0, type: "hidden", orderable: false},
                { data: "name",  defaultContent:"", width: '45%', targets: 1, type: "text",   orderable: false},
                { data: "value", defaultContent:"", width: '45%', targets: 2, type: "text",   orderable: false},
                { data: "langCode", defaultContent:"", visible: false, targets: 3 , type: "hidden", orderable: false},
                { data: null, name: "Action", title: "Action", targets: 4, width: '5%', type: "hidden", orderable: false,
                    render: function (data, type, row, meta) {
                        return '<button type="button" class="btn btn-sm btn-outline-danger button_remove"><i class="ph-trash"></i></button>';
                    },
                    disabled: true
                }
            ];

            // Initialize
            var table = $('.translations-list').DataTable({
                autoWidth: false,
                processing: true,
                serverSide: true,
                deferRender: true,
                stateSave: true,
                ajax: {
                    "url": "{$adminUrl}/translations?action=read_table",
                    "type": 'POST',
                    error: function (e) {
                        console.log(e);
                    },
                    //success: function (data) {
                    //    console.log(data);
                    //}
                },

                columns: columnDefs,
                dom: '<"datatable-header"fl><"toolbar"B><"datatable-scroll-wrap"t><"datatable-footer"ip>',
                language: { "url": "{$GLOBAL_URL}/admin/assets/js/vendor/tables/datatables/lang/{$config.admin_language}.json" },
                lengthMenu: [10, 25, 50, 75, 100],
                displayLength: 10,
                select: true,
                responsive: true,
                altEditor: true,     // Enable altEditor
                buttons: [
                    //{ text: 'Add', name: 'add', className: 'btn bg-blue' },
                    //{ extend: 'selected', className: 'btn bg-blue', text: 'Edit', name: 'edit' },
                    //{ extend: 'selected', className: 'btn bg-blue', text: 'Delete', name: 'delete' },
                    {foreach from=$flags item=flag}
                    { text: '{$flag.codename}', name: '{$flag.languageId}', className: 'btn btn-outline-primary',
                        action: function(e, dt, node, config) {
                            table.ajax.url( '{$adminUrl}/translations?action=read_table&id={$flag.languageId}' ).load();
                        }
                    },
                    {/foreach}
                ],
                onAddRow: function(datatable, rowdata, success, error) {
                    console.log(datatable);
                    if (table.data().any() ) { rowdata.langCode = table.rows(0).data()[0]['langCode']; }
                    $.ajax({ url: "{$adminUrl}/translations?action=add_row", type: 'GET', data: rowdata, success: success, error: error });
                },
                onDeleteRow: function(datatable, rowdata, success, error) {
                    console.log(rowdata);
                    $.ajax({ url: "{$adminUrl}/translations?action=delete_row", type: 'GET', data: rowdata, success: success, error: error });
                },
                onEditRow: function(datatable, rowdata, success, error) {
                    console.log(datatable); // a tipycal url would be /{ id } with type='POST'
                    $.ajax({ url: "{$adminUrl}/translations?action=edit_row", type: 'GET', data: rowdata, success: success, error: error });
                }

            });

            // Edit
            $(document).on('click', "[id^='translations'] tbody ", 'tr', function () {
                var tableID = $(this).closest('table').attr('id');    // id of the table
                var that = $( '#'+tableID )[0].altEditor;
                that._openEditModal();
                $('#altEditor-edit-form-' + that.random_id).off('submit').on('submit', function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    that._editRowData();
                });
            });

            // Delete
            $(document).on('click', "[id^='translations'] .button_remove", 'tr', function (x) {
                var tableID = $(this).closest('table').attr('id');    // id of the table
                var that = $( '#'+tableID )[0].altEditor;
                that._openDeleteModal();
                $('#altEditor-delete-form-' + that.random_id).off('submit').on('submit', function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    that._deleteRow();
                });
                x.stopPropagation(); //avoid open "Edit" dialog
            });

            // Add row
            $('#addbutton').on('click', function () {
                var that = $( '#translations' )[0].altEditor;
                that._openAddModal();
                $('#altEditor-add-form-' + that.random_id).off('submit').on('submit', function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    that._addRowData();
                });
            });
        };


        return {
            init: function() {
                _componentDatatable();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        LangList.init();
    });
</script>
<style>
    .groupright {
        float: left !important;
        padding: 1.25rem 1.25rem 0 1.25rem;
    }
    .toolbar {
        position: relative;
        padding: 1.25rem 1.25rem 0 1.25rem;
    }
</style>

