
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/social?action=add{if !empty($page)}&page={$page}{/if}"><i class="icon-plus3"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/socials" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/socials"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-togglable table-xs table-striped table-hover" id="socials">
						<thead>
						<tr>
							<th data-toggle="true" width="10px">#</th>
							<th data-toggle="true">{socials:title}</th>
							<th data-hide="phone">{socials:urlTable}</th>
							<th data-hide="phone" class="text-center">{general:status}</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if $socials}
							<tbody class="sortable">
                            {foreach item=social from=$socials name=socials}
								<tr id="social-{$social.socialId}" data-id="{$social.socialId}" class="{if $social.status eq 'H'}table-warning{/if}">
									<td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
									<td width="100%"> {$social.name nofilter}</td>
									<td class="text-left">{$social.url}</td>
									<td  class="text-center" id="status-{$social.socialId}">{$social.statusName nofilter}</td>
									<td class="text-left">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/social?action=edit&id={$social.socialId}"><i class="ph-note-pencil me-2"></i></a>
											<div class="dropdown">
												<a  class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

												<div class="dropdown-menu dropdown-menu-right">
													<a class="dropdown-item" href="{$adminUrl}/social?action=edit&id={$social.socialId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
													<button class="dropdown-item ajax_action" data-module="socials" data-action="status" data-id="{$social.socialId}"><i class="{if $social.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i>{general:status}</button>
													<div class="dropdown-divider"></div>
													<button class="dropdown-item text-danger" onclick="newRemove({$social.socialId}, '{$social.name|escape}', 'socials');"><i class="ph-trash me-2"></i> {general:delete}</button>
												</div>
											</div>
										</div>
									</td>
								</tr>
                            {/foreach}

							</tbody>

                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/socials" params="{$buildQueryString}"}
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
        {if isset($errors.errorName)} new Noty({ text: '{socials:errors:0}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.fileNameEmpty)} new Noty({ text: '{socials:errors:1}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.fileNameError)} new Noty({ text: '{socials:errors:2}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{socials:errors:3}', type: 'error', timeout: 1500 }).show();{/if}
        {if isset($messages.saved)} new Noty({ text: '{socials:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
    });


    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/socials?action=reorder", { ids : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
            // location.reload();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })

</script>






