<form method="post" id="statuses" >
	<!-- Page header -->
	{capture name="buttons"}
		<button class="btn btn-sm btn-primary mx-2" type="submit" name="action" value="apply"><i class="ph-check me-2"></i> {general:apply}</button>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/statuses" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<div class="">
						<table class="table table-togglable table-xs table-striped table-hover table_statuses" id="statuses">
							<thead>
							<tr>
								<th data-toggle="true">Статус заказа</th>
								<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
							</tr>
							</thead>

								<tbody class="sortable">
	                            {assign var=status_row value=0}
	                            {if $statuses}
		                            {foreach item=status from=$statuses name=statuses}
										<tr id="status-{$status_row}">
											<td width="100%"><input class="form-control" type="text" name="statuses[{$status_row}][name]" value="{$status.name|default:''}" autocomplete="off" placeholder="Название статуса"/></td>
											<td class="text-left">
												<input class="form-control" type="hidden" name="statuses[{$status_row}][order_status_id]" value="{$status.order_status_id}" />
												<button type="button" class="btn btn-light text-danger p-0" onclick="confirm('Данное действие необратимо. Вы уверены?') ? $('#status-{$status_row}').remove() : false;"><i class="ph-trash"></i></button>
											</td>
										</tr>
		                                {assign var=status_row value=$status_row+1}
		                            {/foreach}
	                            {else}
									<tr><td class="text-center" colspan="2">- {general:none} -</td></tr>
		                        {/if}
								</tbody>
						</table>
					</div>
					<div class="card-footer text-right">
						<button type="button" class="btn btn-outline-primary" onclick="addStatus();">Добавить статус</button>
					</div>
				</div>

			</div>

			<div class="col-md-12 text-center">
                {$smarty.capture.buttons nofilter}
			</div>
		</div>
	</div>
</form>


<script>
    var status_row = {$status_row};

    function addStatus() {
        html  = '<tr id="status-' + status_row + '">';
        html += '    <td><input class="form-control" type="text" name="statuses[' + status_row + '][name]" value="" autocomplete="off" placeholder="Название статуса"/></td>';
        html += '    <td>' +
            '<input class="form-control" type="hidden" name="statuses[' + status_row + '][order_status_id]" value="" />' +
            '<button type="button" class="btn btn-light text-danger p-0" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#status-' + status_row + '\').remove() : false;"><i class="ph-trash"></i></button>' +
            '</td>';
        html += '</tr>';

        $('.table_statuses tbody').append(html);

        status_row++;
    }

</script>






