<form action="{$adminUrl}/maps" method="post" id="map" autocomplete="off">
    {capture name="buttons"}
		<button class="btn btn-sm btn-primary" type="submit" name="action" value="save"><i class="ph-floppy-disk me-2"></i>{general:save}</button>
    {/capture}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/maps" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
    
    
    <!-- Content area -->
    <div class="content">
        <div class="row"> 
            <div class="col-md-6">
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:description}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
	                        <div class="row">
					            <div class="col-md-6">
						            <div class="form-group mb-3">
							            <label class="form-label is-visible">{if isset($map.isMaps) and $map.isMaps eq 1}{settings:map:mapOff}{else}{settings:map:mapOn}{/if}</label>
	                                    {html_options options=$works name="map[isMaps]" id="isMaps" selected=$map.isMaps|default:0 class="form-control select"}
						            </div>
					            </div>
					            <div class="col-md-6">
						            <div class="form-group mb-3">
							            <label class="form-label is-visible">{settings:map:mapType}</label>
							            <select class="form-control select" name="map[type]">
								            <option value="">Выбрать тип карты</option>
								            <option value="yandex" {if isset($map.type) AND $map.type eq 'yandex'}selected{/if}>Yandex карта</option>
								            <option value="google" {if isset($map.type) AND $map.type eq 'google'}selected{/if}>Google карта</option>
							            </select>
						            </div>
					            </div>
					            <div class="col-md-6">
						            <div class="form-group mb-3">
							            <label class="form-label is-visible {if isset($errors.languageName)}text-danger{/if}">{settings:map:mapApi}</label>
							            <input type="text" class="form-control" name="map[api_key]" value="{if isset($map.api_key)}{$map.api_key}{/if}">
						            </div>
					            </div>
	                            <div class="col-md-6">
	                                 <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{settings:map:coordinates}</label>
	                                    <input type="text" class="form-control" name="map[coordinates]" value="{if isset($map.coordinates)}{$map.coordinates}{/if}">
	                                </div>
	                            </div>

	                            <div class="col-md-4">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{settings:map:zoomMap}</label>
	                                    <input type="text" class="form-control" name="map[zoom]" value="{if isset($map.zoom)}{$map.zoom}{/if}">
	                                </div>
	                            </div>
	                            <div class="col-md-4">
	                                <div class="form-group mb-3">
	                                    <label class="form-label">{settings:map:heightMap}</label>
	                                    <input type="text" class="form-control" name="map[maps_height]" value="{if isset($map.maps_height)}{$map.maps_height}{/if}">
	                                </div>
	                            </div>
	                            <div class="col-md-4">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{settings:map:wightMap}</label>
	                                    <input type="text" class="form-control" name="map[maps_wight]" value="{if isset($map.maps_wight)}{$map.maps_wight}{/if}">
	                                </div>
	                            </div>
	                            <div class="col-md-4">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{settings:map:scale}</label>
	                                    <input type="text" class="form-control" name="map[scale]" value="{if isset($map.scale)}{$map.scale}{/if}">
	                                </div>
	                            </div>
	                           <div class="col-md-4">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{settings:map:fillColor}</label>
	                                    <input type="text" class="form-control" name="map[fillColor]" value="{if isset($map.fillColor)}{$map.fillColor}{/if}">
	                                </div>
	                            </div>
	                            <div class="col-md-4">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{settings:map:fillOpacity} </label>
	                                    <input type="text" class="form-control" name="map[fillOpacity]" value="{if isset($map.fillOpacity)}{$map.fillOpacity}{/if}">
	                                </div>
	                            </div>
	                        </div>
	                    </div>
			        </div>
    		    </div>
            </div>

            <div class="col-md-6">
        		<div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:map}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
				        {if isset($map.isMaps) and $map.isMaps eq 1}
					        <div class="block_maps"><div id="map-canvas"></div></div>
				        {/if}
			        </div>
    			</div>
            </div>

	        <div class="col-md-12 main main_buttons text-center">
		        {$smarty.capture.buttons nofilter}
	        </div>
        </div>
    </div>

</form>

<script>
    $(document).ready(function() {
        {if isset($messages.saved)}
            new Noty({ text: '{settings:messages:0}', type: 'success', timeout: 1500 }).show();
	    {/if}
    }); 
</script>

    
{if isset($map.isMaps) and $map.isMaps eq 1}
	{if isset($map.type) and $map.type eq 'google'}
		{google_maps}
	{elseif isset($map.type) and $map.type eq 'yandex'}
	    {yandex_maps}
	{/if}
{/if}