
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/currency?action=add"><i class="icon-plus3"></i></a>
{/capture}
{capture name="breadcrumb"}
	<a href="{$adminUrl}/currencies" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
{/capture}

{capture name="showBy"}
    {if $currencyList|count > 0}
		<button class="btn btn-sm btn-primary" type="button" data-bs-toggle="collapse" data-bs-target="#changeDefaultCurrencyRow">
			<i class="ph-arrows-out-line-vertical me-2"></i>{currency:setDefaultCurrency}
		</button>
    {/if}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div id="changeDefaultCurrencyRow" class="collapse">
				<div class="card border shadow-sm bg-light p-2 d-sm-flex align-items-sm-center">
					<div class="mb-0"></div>
					<div class="ms-sm-auto">
						<ul class="list-inline list-inline-condensed mb-0">
							<li class="list-inline-item text-muted"><i class="ph-arrows-out-line-vertical"></i>{currency:setDefaultCurrency}</li>
							<li class="list-inline-item">
								<form action="{$adminUrl}/currencies" method="post">
									<div class="input-group">
                                        {html_options options=$currencySelectList id=currencyDefaultPretindents name="id" class="form-control select" data-width="300"}
										<button class="btn btn-sm btn-primary" type="submit" name="action" value="setDefaultCurrency" >{currency:buttons:changeDefaultCurrency}</button>
									</div>
								</form>
							</li>
						</ul>
					</div>
				</div>
			</div>


			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-togglable table-xs table-striped table-hover" id="currencys">
						<thead>
						<tr>
							<th data-hide="ID" class="text-center" width="30">#</th>
							<th class="text-left text-nowrap" data-toggle="true">{currency:table:title}</th>
							<th class="text-center text-nowrap"data-hide="phone">{currency:table:codeName}</th>
							<th class="text-left text-nowrap"data-hide="phone">{currency:table:course}</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if !empty($currencyList)}
							<tbody class="sortable">
                            {foreach from=$currencyList item=currency}
								<tr id="currency-{$currency.id}" data-id="{$currency.id}">
									<td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
									<td class="text-left {if $currency.isDefault}strong{/if}">{$currency.title} {if $currency.isDefault} (<b>{currency:default}</b>){/if}</td>
									<td class="text-center">{$currency.codeName}</td>
									<td class="text-left">{$currency.course}</td>
									<td class="text-left">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/currency?action=edit&id={$currency.id}"><i class="ph-note-pencil me-2"></i></a>
											<div class="dropdown">
												<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

												<div class="dropdown-menu dropdown-menu-end">
													<a class="dropdown-item" href="{$adminUrl}/currency?action=edit&id={$currency.id}"><i class="ph-note-pencil me-2"></i>{general:edit}</a>
													<div class="dropdown-divider"></div>
													<button class="dropdown-item text-danger" onclick="remove({$currency.id}, '{$currency.title|escape}', 'currencies');"><i class="ph-trash me-2"></i>{general:delete}</button>
												</div>
											</div>
										</div>
									</td>
								</tr>
                            {/foreach}

							</tbody>

                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/currencies" params="{$buildQueryString}"}
			</div>
		</div>
	</div>
</div>


<script>

    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: '{currency:messages:saved}', type: 'success' }).show(); {/if}
    });

    function deleteSuccess(id) {
        new Noty({ text: '{currency:messages:deleted}', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'currency');
    }


    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
	        $.post( "{$adminUrl}/currencies?action=reorder", { ids : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
            // location.reload();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })

</script>






