<form method="post" class="form-content-wrapper" class="content-inner">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/reviews?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/reviews" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<!-- Content area -->
	<div class="content">

		<div class="row">
			<div class="col-md-8">

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.authorName)}text-danger{/if}">{comments:authorName}</label>
										<input type="text" class="form-control" id="authorName" autocomplete="off" name="comment[authorName]" value="{if isset($comment.authorName)}{$comment.authorName}{/if}"  />
									</div>
								</div>

                                {*                            <div class="col-md-6">*}
                                {*                                <div class="form-group mb-3">*}
                                {*                                    <label class="form-label is-visible {if isset($errors.authorEmail)}text-danger{/if}">{comments:authorEmail}</label>*}
                                {*                                    <input type="text" class="form-control" autocomplete="off" id="authorEmail" name="comment[authorEmail]" value="{if isset($comment->authorEmail)}{$comment->authorEmail}{/if}" />*}
                                {*                                </div>*}
                                {*                              *}
                                {*            			    </div>*}
							</div>
						</div>
					</div>
				</div>


				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">
							<ul class="nav nav-tabs nav-tabs-overline border-top-0">
								<li class="nav-item"><a href="#summary" class="nav-link active show" data-toggle="tab">{comments:commentMessage}</a></li>
                                {*                            <li class="nav-item"><a href="#content" class="nav-link" data-toggle="tab">{comments:commentAnswer}</a></li>*}
							</ul>

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="summary">
									<textarea class="description"  name="comment[content]">{if isset($comment.content)}{$comment.content}{/if}</textarea>
								</div>

                                {*                            <div class="tab-pane fade" id="content">*}
                                {*        					    <textarea class="description"  name="comment[answer]">{if isset($comment->answer)}{$comment->answer}{/if}</textarea>*}
                                {*        				    </div>*}
							</div>
						</div>
					</div>
				</div>

			</div>


			<div class="col-md-4">

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="comment[status]" array=$statuses selected=$comment.status|default:''  class="form-group mb-3"}
                            {* /field status *}

                            {*	                        <div class="form-group mb-3">*}
                            {*	                            <label class="form-label is-visible">{comments:status}</label>*}
                            {*	                            {html_options options=$statuses name="comment[status]" id="status" selected=$comment.status|default:'' class="form-control select"}*}
                            {*	                        </div>*}
						</div>
					</div>
				</div>

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:rating}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div>
								<p class="mb-2 text-muted">Значение рейтинга: <code class="font-weight-semibold" id="noui-stepping-val"></code> </p>
							</div>
							<div class="noui-height-helper" id="noui-slider-snap"></div>
							<input type="hidden" class="form-control ion-height-helper" id="noui-rating" name="comment[rating]" value="{$comment.rating}">
						</div>
					</div>
				</div>
			</div>

			<div class="col-md-12 main main_buttons text-center">
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

<script>
    $(document).ready(function () {
        {if isset($errors.access_denied)} new Noty({ text: '{comments:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{comments:errors:1}', type: 'error' }).show(); {/if}
        {if isset($errors.comment_not_found)} new Noty({ text: '{comments:errors:2}', type: 'error' }).show(); {/if}
        {if isset($errors.authorName)} new Noty({ text: '{comments:errors:4}', type: 'error' }).show();{/if}
        {if isset($errors.authorEmail)} new Noty({ text: '{comments:errors:3}', type: 'error' }).show(); {/if}
        {if isset($errors.authorEmailNot)} new Noty({ text: '{comments:errors:6}', type: 'error' }).show(); {/if}
        {if isset($errors.content)}new Noty({ text: '{comments:errors:5}', type: 'error' }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{comments:messages:0}', type: 'success' }).show(); {/if}
        {if isset($messages.bulk_save)} new Noty({ text: '{comments:messages:1}', type: 'success' }).show(); {/if}
    });

    // rating
    const ratingValue = '{if isset($comment.rating)}{$comment.rating}{/if}';
    const sliderStepping = document.getElementById('noui-slider-snap');
    noUiSlider.create(sliderStepping, { start: [ratingValue], step: 0.1, range: { 'min': [0], 'max': [5] } });
    const sliderSteppingVal = document.getElementById('noui-stepping-val');
    sliderStepping.noUiSlider.on('update', function( values, handle ) {
        sliderSteppingVal.innerHTML = values[handle];
        document.getElementById('noui-rating').value  = values[handle];
    });
</script>


