<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/brands?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/brands" class="breadcrumb-item">{$title}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-8">

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.name)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" id="name" autocomplete="off" name="brand[name]" value="{if isset($brand.name)}{$brand.name}{/if}" onblur="proposeFileName('name', 'fileName', 'brand', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
										<input  type="text" class="form-control" id="fileName" autocomplete="off" name="brand[fileName]" value="{if isset($brand.fileName)}{$brand.fileName}{/if}" />
									</div>
								</div>
                                {*				            <div class="col-md-12">*}
                                {*					            <div class="form-group mb-3">*}
                                {*						            <label class="form-label is-visible">Страна</label>*}
                                {*                                    {html_options options=$countryList name="brand[countryId]" id="status" selected=$brand.countryId|default:'' class="form-control select"}*}
                                {*					            </div>*}
                                {*				            </div>*}
							</div>
						</div>
					</div>
				</div>


				<div class="collapse {if isset($brand.enableGallery) and $brand.enableGallery eq 1}show{/if}" id="gallery-card">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">{general:card:imageLibrary}</h6>
							<div class="d-inline-flex ms-auto"><a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a></div>
						</div>
						<div class="collapse show">
							<div class="card-body">
								<div class="row gallery gallery-product  gallery-sortable mt-2 sortable" id="fileList">
                                    {if isset($brand.gallery)}
                                        {foreach item=file from=$brand.gallery}
											<figure class="gallery-item mb-0" id="gallery-item-{$file.imageId}" data-id="{$file.imageId}">
												<div class="move_zone image">
													<img src="{$file.medium}" alt="{$file.title|default:''}"/>
													<ul class="gallery-item-controls">
														<li><span>{$file.orderBy}</span></li>
														<li>
		                                                    <span class="edit_image" id="edit_image_{$file.imageId}"
		                                                          data-title="{$file.title}"
		                                                          data-alias="{$file.alias}"
		                                                          data-description="{$file.description}"
		                                                          data-link="{$file.link}"
		                                                          data-position="{$file.position}"
		                                                          onclick="editPictureInfo({$file.imageId}, 'Добавить описание к картинке', 'brand');"><i class="icon-quill4"></i></span>
														</li>
														<li>
															<span onclick="deletePicture({$file.imageId}, 'brand');"><i class="icon-cross2"></i></span>
														</li>
													</ul>
												</div>
												<div class="meta" id="meta_image_{$file.imageId}">
													<span id="im_title" class="fs-sm fw-normal fw-semibold">{$file.title}</span>
													<span id="im_alias" class="fs-sm fw-normal">{$file.alias}</span>
													<span id="im_description" class="fs-sm fw-normal">{$file.description nofilter}</span>
													<span id="im_link" class="fs-sm fw-normal">{$file.link}</span>
													<span id="im_position" class="badge bg-primary text-white fs-sm fw-light">{$file.position}</span>
												</div>
											</figure>
                                        {/foreach}
                                    {/if}
								</div>
							</div>
							<div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
								<button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="gallery" data-path="/" data-action="read_more"><i class="ph-image me-2"></i> {general:uploadFiles} </button>
							</div>
						</div>
					</div>
				</div>

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">
							<textarea name="brand[content]" class="description">{if isset($brand.content)}{$brand.content}{/if}</textarea>
						</div>
					</div>
				</div>

			</div>

			<div class="col-md-4">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="brand[status]" array=$statuses selected=$brand.status|default:'visible'  class="form-group mb-3"}
                            {* /field status *}

							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:misc:featured}</label>
								<select name="brand[isFeatured]" class="form-control select">
									<option value="0" {if isset($brand.isFeatured) and $brand.isFeatured eq 0} selected{/if}>{general:no}</option>
									<option value="1" {if isset($brand.isFeatured) and $brand.isFeatured eq 1} selected{/if}>{general:yes}</option>
								</select>
							</div>
							<div class="form-check mb-3">
								<input type="checkbox" class="form-check-input" id="enableGallery" name="brand[enableGallery]" value="1"
                                       {if isset($brand.enableGallery) and $brand.enableGallery eq 1}checked{/if}
								       data-bs-toggle="collapse"
								       data-bs-target="#gallery-card"
								       aria-expanded="{if isset($brand.enableGallery) and $brand.enableGallery eq 1}true{else}false{/if}">
								<label class="form-check-label" for="enableGallery"> Фотогалерея к этой публикации</label>
							</div>
						</div>
						<div class="card-footer hstack gap-3 justify-content-between">
							<div class="text-muted">
								<ul class="list list-unstyled mb-0 fs-sm">
                                    {if isset($brand.addedOn)}<li>{general:created}</li>{/if}
                                    {if isset($brand.modifiedOn)}<li>{general:modified}</li>{/if}
								</ul>
							</div>
							<div class="hstack gap-1">
								<ul class="list list-unstyled mb-0 fs-sm">
                                    {if isset($brand.addedOn)}<li>{$brand.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$brand.addedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
                                    {if isset($brand.modifiedOn)} <li>{$brand.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$brand.modifiedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
								</ul>
							</div>
						</div>

					</div>
				</div>

                {include file="components/image-preview.tpl"
                image="{if isset($brand.image)}{$brand.image.original}{/if}"
                id="{if isset($brand.image)}{$brand.image.imageId}{/if}"
                module='brand'}

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:seo}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>

					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0">

							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:keywords}</label>
								<div class="input-group">
									<input type="text" class="form-control tokenfield-primary" id="keywords" name="brand[keywords]" value="{if isset($brand.keywords)}{$brand.keywords}{/if}" data-fouc>
								</div>
							</div>
							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:description}</label>
								<textarea id="description" name="brand[description]" class="form-control" rows="3">{if isset($brand.description)}{$brand.description}{/if}</textarea>
							</div>
						</div>
					</div>
				</div>

			</div>

			<div class="col-md-12 main main_buttons text-center">
                {if isset($brand.brandId)}<input type="hidden" class="form-control" id="id" name="id" value="{$brand.brandId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>

    $(document).ready(function () {

        {if isset($errors.access_denied)} new Noty({ text: '{brands:errors:0}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.title)} new Noty({ text: '{brands:errors:1}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{brands:errors:3}', type: 'error', timeout: 3000 }).show();{/if}
        {if isset($errors.image_not_saved)} new Noty({ text: '{brands:errors:5}', type: 'error', timeout: 3000 }).show();{/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{brands:errors:6}', type: 'error', timeout: 3000 }).show();{/if}
        {if isset($errors.fileName)} new Noty({ text: '{brands:errors:7}', type: 'error', timeout: 3000 }).show();;{/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{brands:errors:8}', type: 'error', timeout: 1500 }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{brands:messages:0}', type: 'success', timeout: 1500 }).show();{/if}



        // сортировать фотогалею
        $(document).on('click', '.sortable_save_button', function () {
            var ids = new Array();
            $('#fileList figure.gallery-item').each(function () {
                console.log($(this).attr('data-id'))

                ids.push($(this).attr('data-id'));
            })
            $.post("{$adminUrl}/brand?action=sortPictures", { imageIds : ids }, function() {
                $('.sortable_footer_navbar').removeClass('show');
                $("#fileList").load(location.href + " figure.gallery-item");
                new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
            });
        })
        $(document).on('click', '.sortable_cancel_button', function () {
            $('.sortable_footer_navbar').removeClass('show');
            $("#fileList").load(location.href + " figure.gallery-item");
        })

    });

    $(function () {
        function e() { keywords_touched || $("#keywords").val(i()), description_touched || $("#description").val(t()), fileName_touched || $("#fileName").val(n()) }
        function i() { return name = $("#name").val() }
        function t() { return name = $("#name").val() }
        function n() { return fileName = $("#name").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() }
        function l(e) {
            for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) {
                var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
            }
            return t
        }
        keywords_touched = !0, description_touched = !0, fileName_touched = !0,
        ($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1),
        ($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1),
        ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1),
            $("#keywords").change(function () { keywords_touched = !0 }),
            $("#description").change(function () { description_touched = !0 }),
            $("#fileName").change(function () { fileName_touched = !0 }),
            $("#name").keyup(function () { e() })
    });


</script>
