
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/bannergroup?action=add"><i class="icon-plus3"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/bannergroups" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/bannergroups"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<div class="content">

	<div class="row">
		<div class="col-md-12">
			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-togglable table-xs table-striped table-hover" id="bannergroups">
						<thead>
						<tr>
							<th data-hide="ID" class="text-center" width="30">#</th>
							<th data-toggle="true">Название группы</th>
							<th data-hide="pages">Отображение</th>
							<th data-hide="phone" class="text-center">{general:status}</th>
							<th class="text-center text-muted" width="50"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if !empty($groups)}
							<tbody class="sortable">

                            {foreach item=group from=$groups name=groups}
								<tr id="bannergroup-{$group.groupId}" data-id="{$group.groupId}" class="{if $group.status eq 'H'}table-warning{/if}">
									<td class="text-center text-nowrap"><i class="ph-dots-six text-muted" data-bs-popup="popover-solid" data-bs-trigger="hover" title="Переместить"></i></td>
									<td class="text-left" width="100%">{$group.name|escape}</td>
									<td class="text-nowrap">Разделы: {if isset($group.pageNames)}{foreach from=$group.pageNames item=pageName}<span class="badge bg-warning">{$pageName}</span> {/foreach}{/if}</td>
									<td class="text-center text-nowrap" id="status-{$group.groupId}">{$group.statusName}</td>
									<td class="text-center">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/bannergroup?action=edit&id={$group.groupId}"><i class="ph-note-pencil me-2"></i></a>
											<div class="list-icons-item dropdown">
												<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

												<div class="dropdown-menu dropdown-menu-end">
													<a class="dropdown-item" href="{$adminUrl}/bannergroup?action=edit&id={$group.groupId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
													<button class="dropdown-item ajax_action" data-module="bannergroups" data-action="status" data-id="{$group.groupId}"><i class="{if $group.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
													<div class="dropdown-divider"></div>
													<button type="button" class="dropdown-item text-danger" onclick="newRemove({$group.groupId}, '{$group.name|escape}', 'bannergroups');"><i class="ph-trash me-2"></i> {general:delete}</button>
												</div>
											</div>
										</div>
									</td>
								</tr>
                            {/foreach}
							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="6">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/bannergroups" params="{$buildQueryString}"}
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function () {
        {if isset($errors.not_saved)} new Noty({ text: 'Группа баннеров не сохранена', type: 'error' }).show(); {/if}
        {if isset($errors.group_not_found)} new Noty({ text: 'Группа баннеров не найдена', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Группа баннеров сохранена', type: 'success' }).show(); {/if}
    });

    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/bannergroups?action=reorder", { ids : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
            // location.reload();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })

</script>


