
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/ad?action=add"><i class="icon-plus3"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/ads" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/ads"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<div class="content">

	<div class="card">
        {if isset($action) && $action == 'generateCode'}
			<div class="">
				<table align="center">
					<tr>
						<td><b>{banners:directCode}:</b><br /><textarea cols="100" rows="5">{if isset($banner.frame)}{$banner.frame|escape}{/if}</textarea></td>
					</tr>
					<tr>
						<td><input type="button" onclick="location.href='{$adminUrl}/banner'" value="{banners:listBanners}"></td>
					</tr>
				</table>
			</div>

        {else}
			<div class="">
				<table class="table table-togglable table-striped table-hover" id="banners">
					<thead>
					<tr>
						<th data-hide="ID" class="text-center" width="30">{users:table:id}</th>
						<th data-hide="image">{banners:tableTitle}</th>
						<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
					</tr>
					</thead>
                    {if isset($adBanners)}
						<tbody>
                        {foreach item=banner from=$adBanners}
							<tr id="banner-{$banner.bannerId}">
								<td>{$banner.bannerId} </td>
								<td class="text-nowrap" width="100%">{$banner.bannerName}</td>
								<td class="text-center">
									<div class="d-inline-flex">
										<div class="dropdown">
											<a href="javascript:void('');" class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

											<div class="dropdown-menu dropdown-menu-end">
												<a class="dropdown-item" href="{$adminUrl}/ad?action=edit&id={$banner.bannerId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
												<div class="dropdown-divider"></div>
												<button class="dropdown-item text-danger"  onclick="newRemove({$banner.bannerId}, '{$banner.bannerName|escape}', 'ads');"><i class="ph-trash me-2"></i> {general:delete}</button>
											</div>
										</div>
									</div>
								</td>
							</tr>
                        {/foreach}

						</tbody>

                    {else}
						<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                    {/if}
				</table>
			</div>
        {/if}
	</div>
</div>


<script>

    $(document).ready(function () {

        {if isset($errors.access_denied)} new Noty({ text: '{banners:errors:1}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{banners:errors:0}', type: 'error', timeout: 1500 }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{banners:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

    });


</script>



