<script src="/admin/assets/js/vendor/visualization/echarts/echarts.min.js"></script>
{*<script src="/admin/assets/js/demo_pages/charts/echarts/candlesticks_others.js"></script>*}
<script>

    var EchartsColumnsWaterfalls = function() {

        const _columnsWaterfallsExamples = function() {
            if (typeof echarts == 'undefined') {
                console.warn('Warning - echarts.min.js is not loaded.');
                return;
            }

            const stats_users_element = document.getElementById('stats_users');
            const stats_content_element = document.getElementById('stats_content');

            {if isset($days)}

                if (stats_users_element) {
                    var users_element = echarts.init(stats_users_element);
                    users_element.setOption({
                        title: { text: '{stats:visitors}', left: 'left', textStyle: { fontSize: 17, fontWeight: 500 }, subtextStyle: { fontSize: 12 } },
                        // Define colors
                        color: ['#2ec7c9','#b6a2de','#5ab1ef','#ffb980','#d87a80'],
                        // Global text styles
                        textStyle: { fontFamily: 'Roboto, Arial, Verdana, sans-serif', fontSize: 13 },
                        // Chart animation duration
                        animationDuration: 750,
                        // Setup grid
                        grid: { left: 0, right: 25, top: 50, bottom: 0, containLabel: true },
                        // Add legend
                        legend: {
                            data: [ '{stats:newVisitors}', '{stats:returningVisitors}', '{stats:totalVisitors}' ],
                            itemHeight: 8,
                            itemGap: 20,
                            textStyle: { padding: [0, 5] }
                        },

                        // Add tooltip
                        tooltip: {
                            trigger: 'axis',
                            backgroundColor: 'rgba(0,0,0,0.75)',
                            padding: [10, 15],
                            textStyle: { fontSize: 13, fontFamily: 'Roboto, sans-serif' },
                            axisPointer: {
                                type: 'shadow'
                            }
                        },

                        // Horizontal axis
                        xAxis: [{
                            type: 'category',
                            data: [{foreach item=day from=$days name=days} '{$day.date}'{if !$smarty.foreach.days.last},{/if} {/foreach}],
                            axisLabel: { color: '#333' },
                            axisLine: { lineStyle: { color: '#999' } },
                        }],

                        // Vertical axis
                        yAxis: [{
                            type: 'value',
                            axisLabel: { color: '#333' },
                            axisLine: { lineStyle: { color: '#999' } },
                            splitLine: { lineStyle: { color: ['#eee'] } },
                            splitArea: { show: true, areaStyle: { color: ['rgba(250,250,250,0.1)', 'rgba(0,0,0,0.01)'] }}
                        }],

                        // Add series
                        series: [
                            {
                                name: '{stats:newVisitors}',
                                type: 'bar',
                                data: [{foreach item=day from=$days name=days} {$day.newVisitors}{if !$smarty.foreach.days.last}, {/if}{/foreach}],
                                itemStyle: { normal: { label: { show: true, position: 'top', textStyle: { fontWeight: 500 } } } },
                            },
                            {
                                name: '{stats:returningVisitors}',
                                type: 'bar',
                                data: [{foreach item=day from=$days name=days} {$day.retVisitors}{if !$smarty.foreach.days.last}, {/if}{/foreach}],
                                itemStyle: { normal: { label: { show: true, position: 'top', textStyle: { fontWeight: 500 } } } },
                            },
                            {
                                name: '{stats:totalVisitors}',
                                type: 'bar',
                                data: [{foreach item=day from=$days name=days} {$day.newVisitors+$day.retVisitors}{if !$smarty.foreach.days.last}, {/if}{/foreach}],
                                itemStyle: { normal: { label: { show: true, position: 'top', textStyle: { fontWeight: 500 } } } },
                            }
                        ]
                    });
                }

                if (stats_content_element) {
                    var content_element = echarts.init(stats_content_element);
                    content_element.setOption({
                        title: { text: '{stats:visits}', left: 'left', textStyle: { fontSize: 17, fontWeight: 500 }, subtextStyle: { fontSize: 12 } },
                        // Define colors
                        color: ['#C23431','#2F4554','#61A0A8','#b6a2de','#2ec7c9'],
                        // Global text styles
                        textStyle: { fontFamily: 'Roboto, Arial, Verdana, sans-serif', fontSize: 13 },
                        // Chart animation duration
                        animationDuration: 750,
                        // Setup grid
                        grid: { left: 0, right: 25, top: 50, bottom: 0, containLabel: true },
                        // Add legend
                        legend: {
                            data: [ 'Просмотр страниц', 'Просмотр контента', '{stats:totalVisits}' ],
                            itemHeight: 8,
                            itemGap: 20,
                            textStyle: { padding: [0, 5] }
                        },
                        // Add tooltip
                        tooltip: {
                            trigger: 'axis',
                            backgroundColor: 'rgba(0,0,0,0.75)',
                            padding: [10, 15],
                            textStyle: { fontSize: 13, fontFamily: 'Roboto, sans-serif' },
                            axisPointer: {
                                type: 'shadow'
                            }
                        },

                        // Horizontal axis
                        xAxis: [{
                            type: 'category',
                            data: [{foreach item=day from=$days name=days} '{$day.date}'{if !$smarty.foreach.days.last},{/if} {/foreach}],
                            axisLabel: { color: '#333' },
                            axisLine: { lineStyle: { color: '#999' } },
                        }],

                        // Vertical axis
                        yAxis: [{
                            type: 'value',
                            axisLabel: { color: '#333' },
                            axisLine: { lineStyle: { color: '#999' } },
                            splitLine: { lineStyle: { color: ['#eee'] } },
                            splitArea: { show: true, areaStyle: { color: ['rgba(250,250,250,0.1)', 'rgba(0,0,0,0.01)'] }}
                        }],

                        // Add series
                        series: [
                            {
                                name: 'Просмотр страниц',
                                type: 'bar',
                                data: [{foreach item=day from=$days name=days} {$day.sectionVisits}{if !$smarty.foreach.days.last},{/if}{/foreach}],
                                itemStyle: { normal: { label: { show: true, position: 'top', textStyle: { fontWeight: 500 } } } },
                            },
                            {
                                name: 'Просмотр контента',
                                type: 'bar',
                                data: [{foreach item=day from=$days name=days} {$day.articleVisits}{if !$smarty.foreach.days.last},{/if}{/foreach}],
                                itemStyle: { normal: { label: { show: true, position: 'top', textStyle: { fontWeight: 500 } } } },
                            },
                            {
                                name: '{stats:totalVisits}',
                                type: 'bar',
                                data: [{foreach item=day from=$days name=days} {$day.articleVisits+$day.sectionVisits+$day.searchVisits}{if !$smarty.foreach.days.last},{/if}{/foreach}],
                                itemStyle: { normal: { label: { show: true, position: 'top', textStyle: { fontWeight: 500 } } } },
                            }
                        ]
                    });
                }

            {/if}

            // Resize function
            var triggerChartResize = function() {
                stats_users_element && users_element.resize();
                stats_content_element && content_element.resize();
            };

            // On sidebar width change
            $(document).on('click', '.sidebar-control', function() {
                setTimeout(function () {
                    triggerChartResize();
                }, 0);
            });

            // On window resize
            var resizeCharts;
            window.onresize = function () {
                clearTimeout(resizeCharts);
                resizeCharts = setTimeout(function () {
                    triggerChartResize();
                }, 200);
            };
        };

        // Return objects assigned to module
        return {
            init: function() {
                _columnsWaterfallsExamples();
            }
        }
    }();


    // Initialize module
    // ------------------------------

    document.addEventListener('DOMContentLoaded', function() {
        EchartsColumnsWaterfalls.init();
    });

</script>