<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

/**
 * Class TemplatesAdmin
 * @package Mnv\Admin\Controllers
 */
class TemplatesAdmin extends AdminMnv
{

    public function fetch()
    {

        $this->smarty->assign('activeItem','template');
        $this->smarty->assign('title', lang('templates:title'));

        $template = $this->request->get('template', '');

        if ($this->action === 'save') {
            if (!empty($template['isNew'])) {
                if (empty($template['fileName'])) {
                    $this->errors['fileName'] = true;
                }

                $template['fileName'] = str_replace(' ', '_', $template['fileName']);

                if (preg_match('/[^0-9a-zA-Z\-_\. ]/i', $template['fileName'])) {
                    $this->errors['fileNameCharacters'] = true;
                }
                $templates = searchDir(THEME_ROOT, '*.tpl');
                if (in_array($template['fileName'] . '.tpl', $templates, true)) {
                    $this->errors['fileNameExists'] = true;
                }
            }
            if (empty($this->errors)) {
                if (!empty($template['isNew'])) {
                    $template['fileName'] = $template['fileName'] . '.tpl';
                }

//                if ($template->save($template)) {
//                    $this->messages['saved_new_file'] = true;
//                    $this->logger->info("Создан новый шаблон «" . $template['fileName'] . "».", $this->managers->manager);
//                } else {
//                    $this->errors['not_saved'] = true;
//                }
            } else {
                $this->smarty->assign('template', $template);
            }
        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('template')) {
            return $this->smarty->fetch('views/templates/templates.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}








	
	
	
	
	