<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Orders;

/**
 * Class OrderInfoAdmin
 * @package Mnv\Admin\Controllers
 */
class OrderInfoAdmin extends AdminMnv
{

    public function fetch()
    {
        $orders = new Orders($this->request);

        $this->smarty->assign('activeItem','orders');
        $this->smarty->assign('title', lang('orders:title'));
        $this->smarty->assign('statuses', lang('orders:statuses'));

        if ($this->action == 'edit') {

            $orders->edit();
        }
        else if ($this->action == 'save') {

            if ($orders->prepare($orders->data, $this->manager['userId'])) {
                $this->messages['saved'] = true;
            }
            redirect($this->adminUrl . "/orders?" . $this->buildQueryString(['page' => $this->page]));
        }


        $this->smarty->assign('order', $orders->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('orders')) {
            return $this->smarty->fetch('views/orders/order-info.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}