<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Orders;

/**
 * Class OrderAdmin
 * @package Mnv\Admin\Controllers
 */
class OrderAdmin extends AdminMnv
{

    public function fetch()
    {
        $orders = new Orders($this->request);

        $this->smarty->assign('activeItem','orders');
        $this->smarty->assign('title', lang('orders:title'));
        $this->smarty->assign('statuses', lang('orders:statuses'));
        $this->smarty->assign('order_statuses', $orders->orderStatuses());



        if ($this->action == 'edit') {

            $orders->edit();
        }
        else if ($this->action == 'apply' || $this->action == 'save') {


            if ($orders->prepare($orders->data, $this->manager['userId'])) {
                $this->messages['saved'] = true;
            } else {
                $this->errors['not_saved'] = true;
            }

            $orders->edit();

            if (empty($this->errors) && $this->action === 'save') {


                redirect($this->adminUrl . "/order" . $this->buildQueryString(['page' => $this->page]));
            }
        }
        else if ($this->action == 'edit_product') {

            $totalPrice = 0;
            foreach ($orders->product as $product) {
                if (isset($product['option'])) {
                    $option = $product['option'];
                } else {
                    $option = array();
                }
                $totalPrice += $orders->editCartProducts($product['product_id'], $product['quantity'], $option);
            }

            $orders->updateTotals($totalPrice);

            response()->json(array('status' => 200, 'message' => "Success: You have modified your shopping cart!", 'type' => 'success'), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        else if ($this->action == 'remove_product') {

//                $orders->removeCartProduct();

            response()->json(array('status' => 200, 'message' => "Success: You have modified your shopping cart!", 'type' => 'success'), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }


        $this->smarty->assign('order', $orders->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('orders')) {
            return $this->smarty->fetch('views/orders/order.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}