<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Test\Logger;

use Mnv\Models\Users\UserGroups;

/**
 * Class ManagerGroupAdmin
 * @package Mnv\Admin\Controllers
 */
class ManagerGroupAdmin extends AdminMnv
{

    public function fetch()
    {

        $userGroup = new UserGroups($this->request);

        $this->smarty->assign('activeItem', 'managergroups');
        $this->smarty->assign('title', "Группы пользователей");

        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1, 2));

        $this->smarty->assign('permission', $this->accessRights());

        if ($this->action == 'add' || $this->action == 'edit') {

            $userGroup->edit()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** groupName */
            if (empty($userGroup->data['groupName'])) $this->errors['nameEmpty'] = true;
            if (empty($userGroup->data['fileName'])) $this->errors['fileNameEmpty'] = true;
            if (empty($userGroup->privileges)) $this->errors['privilegesEmpty'] = true;

            /** проверяем существование loginName */
            if(preg_match('/[^a-zA-Z\-_\.,]/i', $userGroup->data['fileName'])) $this->errors['fileNameCharacters'] = true;
            if ($fileName = $userGroup->checkFileName($userGroup->data['fileName'])) {
                if ($fileName == $userGroup->data['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $userGroup->data['fileName'] = $fileName;
                }
            }

            $userGroup->data['letter'] = strtoupper(substr($userGroup->data['fileName'], 0, 1)) ;

            if (empty($this->errors)) {
                if ($userGroup->prepare($userGroup->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $userGroup->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/managergroups");
            }

        }

        $this->smarty->assign('group', $userGroup->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if ($this->permissions('managergroups')) {
            return $this->smarty->fetch('views/users/group.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }


}
