<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Locale\Charset;
use Mnv\Core\Locale\LanguageSelection;

use Mnv\Models\Languages;

/**
 * Class LanguagesAdmin
 * @package Mnv\Admin\Controllers
 */
class LanguagesAdmin extends AdminMnv
{

    public function fetch()
    {
        global $LANGUAGES;

        $language = new Languages($this->request);

        $this->smarty->assign('activeItem','langs');
        $this->smarty->assign('title', lang('languages:title'));


        if ($language->isMultiLang()) {
            return $this->smarty->fetch('language.tpl');
        }

        /** изменение основного языка */
        if ($this->action == 'changeDefaultLanguage') {

            if ($language->changeDefaultLanguage()) {
                redirect($this->adminUrl . '/langs');
            } else {
                $this->errors['language_not_found'] = true;
            }
        }
        /** подтверждение на удаление */
        else if ($this->action == 'confirmDelete') {
            if ($language->confirmDelete()) {
                if (!empty($language->language['isDefault']) && count($LANGUAGES) > 1) {
                    redirect($this->adminUrl . '/langs');
                } else {
                    $this->smarty->assign('language', $language->data);
                }
            } else {
                $this->errors['language_not_found'] = true;
            }
        }
        /** удаление */
        else if ($this->action == 'remove') {
            if ($language->remove()) {
                $this->messages['deleted'] = true;
            } else {
                $this->errors['language_not_found'] = true;
            }
        }
        /** изменение статуса */
        else if ($this->action == 'status') {

            $result = $language->status()
                ? array('data' => true, 'status' => $language->status, 'type' => 'success')
                : array('data' => false, 'status' => $language->status, 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }
        /** сортировка */
        else if ($this->action == 'reorder') {
            $language->reorder();
            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }

        $defaultLanguageOptions = array();
        $languages = collect($language->all($this->limit, $this->page))->map(function ($item) use (&$defaultLanguageOptions) {
            $item['languageTransName'] = lang('languageList:' . $item['codename']);
            $item['statusName'] =  lang('languages:statuses:' . $item['status']);
            if (!$item['isDefault']) {
                $defaultLanguageOptions[$item['languageId']] = lang('languageList:' . $item['codename']);
            }
            return $item;
        })->all();

        /** pagination */
        $language->total();
        $pages = getPageNums($language->total, $this->page, $this->limit, 0, 4, 4, 0);

        /** вывод в шаблон результатов */
        $this->smarty->assign('totalLanguages', $language->total);

        $this->smarty->assign('defaultLanguageOptions', $defaultLanguageOptions);
        $this->smarty->assign('languages', $languages);
        $this->smarty->assign('pageNums', $pages);

        $this->smarty->assign('languageOptions', LanguageSelection::$languageOptions);
        $this->smarty->assign('languageCharsets', Charset::$languageCharsets);
        $this->smarty->assign('charsetOptions', Charset::$charsetOptions);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if ($this->permissions('langs')) {
            return $this->smarty->fetch('views/languages/languages.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }

}



