<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Models\Users\UserTypes;

/**
 * Class DocumentCollectionAdmin
 * @package Mnv\Admin\Controllers
 */
class DocumentCollectionAdmin extends AdminMnv
{

    public function fetch()
    {
        $this->smarty->assign('activeItem', 'collection');
        $this->smarty->assign('title', 'Коллекция');


        try {
            if ($this->manager['userType'] == UserTypes::DEVELOPER) {
                return $this->smarty->fetch('views/documents/collection.tpl');
            }

            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');

        } catch (\SmartyException | \Exception $e) {
            return $e->getMessage();
        }
    }

}